/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.sources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.ConfigurationOverrides;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.metadata.keys.OnTableRowKeysResolver;
import com.mulesoft.connectors.google.bigquery.internal.metadata.output.OnTableRowOutputMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.params.NonEntityRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.params.OnTableRowParameterGroup;
import com.mulesoft.connectors.google.bigquery.internal.params.QueryRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.service.paging.OnTableRowQueryPagingProvider;
import com.mulesoft.connectors.google.bigquery.internal.util.QueryHelper;
import com.mulesoft.connectors.google.bigquery.internal.util.RequestBuilderCreator;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisplayName(value="On Table Row")
@Summary(value="Returns all rows of a table based on a watermark")
@MetadataScope(outputResolver=OnTableRowOutputMetadataResolver.class, keysResolver=OnTableRowKeysResolver.class)
@Alias(value="on-table-row")
@MediaType(value="application/json")
@ClusterSupport(value=SourceClusterSupport.DEFAULT_ALL_NODES)
@BackPressure(supportedModes={BackPressureMode.WAIT}, defaultMode=BackPressureMode.WAIT)
public class OnTableRowSource
extends PollingSource<String, HttpResponseAttributes> {
    private static final Logger logger = LoggerFactory.getLogger(OnTableRowSource.class);
    public static final String JOB_REFERENCE_JOB_ID_FIELD_PATH = "jobReference.jobId";
    public static final int MAX_RESULTS = 20;
    @Config
    private RestConfiguration config;
    @MetadataKeyId(value=OnTableRowKeysResolver.class)
    @ParameterGroup(name="onTableRowParameterGroup")
    private OnTableRowParameterGroup onTableRowParameterGroup;
    @Connection
    private ConnectionProvider<RestConnection> connectionProvider;
    @Inject
    protected MuleExpressionLanguage expressionExecutor;
    @Inject
    protected TransformationService transformationService;
    private Serializable effectiveSinceValue;

    public void doStart() {
        BindingContext bindingContext = BindingContext.builder().build();
        if (!StringUtils.isBlank((String)this.onTableRowParameterGroup.getSince())) {
            TypedValue sinceTypedValue = this.expressionExecutor.evaluate(this.onTableRowParameterGroup.getSince(), DataType.OBJECT, bindingContext);
            Object sinceValue = sinceTypedValue.getValue();
            if (!(sinceValue instanceof Serializable)) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The since field has to be of a java serializable class, e.g.: String, Number, Integer, ... "));
            }
            this.effectiveSinceValue = (Serializable)sinceValue;
        }
    }

    public void doStop() {
    }

    public void poll(PollContext<String, HttpResponseAttributes> pollContext) {
        logger.debug("Invoking poll with pollContext {}", pollContext);
        try {
            logger.debug("Getting connection for poll");
            RestConnection connection = (RestConnection)this.connectionProvider.connect();
            logger.debug("Connection established for poll");
            NonEntityRequestParameters nonEntityRequestParameters = new NonEntityRequestParameters();
            ConfigurationOverrides overrides = new ConfigurationOverrides(this.config.getResponseTimeout(), this.config.getResponseTimeoutUnit(), this.config.getStreamingType());
            Serializable since = pollContext.getWatermark().orElse(this.effectiveSinceValue);
            TypedValue<InputStream> queryValuesContent = new QueryHelper(this.config, this.onTableRowParameterGroup, 20).getRowsQuery(Optional.ofNullable(since));
            Function<RestConnection, RestRequestBuilder> requestFactory = RequestBuilderCreator.queryRequestBuilderFunction(queryValuesContent, nonEntityRequestParameters, overrides);
            OnTableRowQueryPagingProvider pagingProvider = new OnTableRowQueryPagingProvider(this.config, requestFactory, (ExpressionLanguage)this.expressionExecutor, null, org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON.withCharset(queryValuesContent.getDataType().getMediaType().getCharset().orElse(this.config.getCharset())), overrides.getResponseTimeout(), overrides.getResponseTimeoutUnit(), new QueryRequestParameters(JOB_REFERENCE_JOB_ID_FIELD_PATH, nonEntityRequestParameters, overrides, String.valueOf(20)));
            logger.debug("Retrieving a page");
            List<Result> nextPageResults = pagingProvider.getPage(connection);
            logger.debug("Retrieved a page");
            while (!nextPageResults.isEmpty() && !pollContext.isSourceStopping()) {
                nextPageResults.forEach(row -> {
                    if (!pollContext.isSourceStopping()) {
                        this.processRow(pollContext, (Result<String, HttpResponseAttributes>)row);
                    }
                });
                logger.debug("Retrying a page");
                nextPageResults = pagingProvider.getPage(connection);
            }
        }
        catch (ConnectionException e) {
            pollContext.onConnectionException(e);
        }
        catch (MuleRuntimeException e) {
            if (e.getCause() != null && InterruptedException.class.equals(e.getCause().getClass()) && pollContext.isSourceStopping()) {
                logger.info("The Source was stopped and interrupted while generating polling items");
            } else {
                logger.error("There was an error while retrieving the pages", (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            logger.error("There was an error while retrieving the pages", (Throwable)e);
        }
        logger.debug("Finished poll");
    }

    private void processRow(PollContext<String, HttpResponseAttributes> pollContext, Result<String, HttpResponseAttributes> row) {
        pollContext.accept(item -> {
            try {
                Result.Builder resultBuilder = Result.builder().output(row.getOutput()).mediaType(org.mule.runtime.api.metadata.MediaType.APPLICATION_JSON);
                row.getAttributes().ifPresent(arg_0 -> ((Result.Builder)resultBuilder).attributes(arg_0));
                row.getAttributesMediaType().ifPresent(arg_0 -> ((Result.Builder)resultBuilder).attributesMediaType(arg_0));
                JsonNode rowJsonNode = this.config.getObjectMapper().readTree((String)row.getOutput());
                item.setResult(resultBuilder.build());
                this.getWatermark(rowJsonNode).ifPresent(arg_0 -> ((PollContext.PollItem)item).setWatermark(arg_0));
                this.getId(rowJsonNode).ifPresent(arg_0 -> ((PollContext.PollItem)item).setId(arg_0));
            }
            catch (JsonProcessingException e) {
                logger.warn("Mapping failed", (Throwable)e);
            }
        });
    }

    public void onRejectedItem(Result<String, HttpResponseAttributes> result, SourceCallbackContext sourceCallbackContext) {
        logger.debug("Row has been rejected for processing: {}", result.getOutput());
    }

    private Optional<String> getId(JsonNode row) {
        Optional<String> id = Optional.ofNullable(row.get(this.onTableRowParameterGroup.getColumnId())).map(JsonNode::toString);
        if (!id.isPresent()) {
            logger.debug("A null ID value was obtained for row {}. Idempotency will not be enforced for this row", (Object)row);
        }
        return id;
    }

    private Optional<Serializable> getWatermark(JsonNode row) {
        Optional<JsonNode> watermarkJsonNode = Optional.ofNullable(row.get(this.onTableRowParameterGroup.getWatermarkColumn()));
        return this.getSerializableValue(row, watermarkJsonNode);
    }

    private Optional<Serializable> getSerializableValue(JsonNode row, Optional<JsonNode> watermarkJsonNode) {
        if (!watermarkJsonNode.isPresent() || watermarkJsonNode.get().isNull()) {
            logger.debug("A null watermark/id value was obtained for row {}. watermark/id value won't be used for this row", (Object)row);
            return Optional.empty();
        }
        if (watermarkJsonNode.get().isNumber()) {
            return Optional.of(watermarkJsonNode.get().numberValue());
        }
        if (watermarkJsonNode.get().isTextual()) {
            return Optional.of(watermarkJsonNode.get().asText());
        }
        logger.error("Watermark/Id values need to be serializable, but a value of type {} was found instead for row {}", (Object)watermarkJsonNode.get().getClass().getName(), (Object)row);
        return Optional.empty();
    }
}

