/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.service.paging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.mulesoft.connectors.google.bigquery.api.param.HttpPagedResponseAttributes;
import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.api.param.response.TableSchema;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.error.exception.RequestException;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.google.bigquery.internal.util.RestSdkUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestPagingProvider
implements PagingProvider<RestConnection, Result> {
    public static final String SCHEMA = "schema";
    private final RestConfiguration config;
    protected final ExpressionLanguage expressionLanguage;
    protected final int responseTimeout;
    protected final TimeUnit responseTimeoutTimeUnit;
    protected final MediaType defaultMediaType;
    private final Function<RestConnection, RestRequestBuilder> requestFactory;
    private final StreamingHelper streamingHelper;
    private final String pageableField;
    private boolean stopPaging = false;
    private boolean firstPage = true;
    private static final Logger logger = LoggerFactory.getLogger(RestPagingProvider.class);
    private static final String UNAUTHORIZED = "UNAUTHORIZED";

    protected RestPagingProvider(RestConfiguration config, Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper, String pageableField, MediaType defaultMediaType, int responseTimeout, TimeUnit responseTimeoutTimeUnit) {
        this.config = config;
        this.requestFactory = requestFactory;
        this.streamingHelper = streamingHelper;
        this.expressionLanguage = expressionLanguage;
        this.responseTimeout = responseTimeout;
        this.responseTimeoutTimeUnit = responseTimeoutTimeUnit;
        this.pageableField = pageableField;
        this.defaultMediaType = defaultMediaType;
    }

    protected abstract void configureRequest(RestRequestBuilder var1);

    protected RestConfiguration getConfig() {
        return this.config;
    }

    protected Result setTableInAttributes(Result result, JsonNode rawResultJsonNode) {
        try {
            if (result.getAttributes().isPresent()) {
                Optional attributesMediaType = result.getAttributesMediaType();
                if (attributesMediaType.isPresent()) {
                    return this.getAttributes(result, rawResultJsonNode).attributesMediaType((MediaType)attributesMediaType.get()).build();
                }
                return this.getAttributes(result, rawResultJsonNode).build();
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error when trying to extract table schema"));
        }
        return result;
    }

    private Result.Builder getAttributes(Result result, JsonNode rawResultJsonNode) throws JsonProcessingException {
        return Result.builder().output(result.getOutput()).attributes((Object)this.getHttpPagedResponseAttributes(result, this.getSchemaFromRawResultJsonNode(rawResultJsonNode)));
    }

    private TableSchema getSchemaFromRawResultJsonNode(JsonNode rawResultJsonNode) throws JsonProcessingException {
        return this.getTableSchemaFromRawResultJsonNode(rawResultJsonNode.get(SCHEMA));
    }

    private <O, P> HttpPagedResponseAttributes getHttpPagedResponseAttributes(Result<O, P> result, TableSchema tableSchema) {
        Optional attributes = result.getAttributes();
        if (attributes.isPresent()) {
            return new HttpPagedResponseAttributes((HttpResponseAttributes)attributes.get(), tableSchema);
        }
        throw new NoSuchElementException("There are no attributes");
    }

    private TableSchema getTableSchemaFromRawResultJsonNode(JsonNode jsonNode) throws JsonProcessingException {
        return (TableSchema)this.getConfig().getObjectMapper().treeToValue((TreeNode)jsonNode, TableSchema.class);
    }

    public List doGetPage(RestConnection connection) {
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        RestRequestBuilder requestBuilder = this.getRequestBuilder(connection);
        this.configureRequest(requestBuilder);
        if (this.stopPaging) {
            return Collections.emptyList();
        }
        Result result = this.getResult(connection, requestBuilder);
        JsonNode rawResultJsonNode = this.getRawJsonNode(result);
        logger.debug("Raw page result JsonNode : {}", (Object)rawResultJsonNode);
        if (rawResultJsonNode.isEmpty() || !rawResultJsonNode.has(this.pageableField)) {
            this.stopPaging();
            IOUtils.closeQuietly((Closeable)((Closeable)result.getOutput()));
            return Collections.emptyList();
        }
        List<Result> pageResults = this.extractPayload(result = this.onProcessResult(result, rawResultJsonNode), rawResultJsonNode);
        if (pageResults.isEmpty()) {
            return Collections.emptyList();
        }
        logger.debug("Rest Page : {}", pageResults);
        this.setNextPage();
        this.onPage(pageResults, rawResultJsonNode, result.getAttributes().orElse(null));
        return pageResults;
    }

    private JsonNode getRawJsonNode(Result<InputStream, HttpResponseAttributes> result) {
        JsonNode rawResultJsonNode;
        try {
            rawResultJsonNode = this.config.getObjectMapper().readTree(this.consumeStringAndClose((InputStream)result.getOutput(), com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.resolveCharset((Optional)result.getMediaType(), (MediaType)this.defaultMediaType)));
        }
        catch (JsonProcessingException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not read json from the result"), (Throwable)e);
        }
        return rawResultJsonNode;
    }

    private Result<InputStream, HttpResponseAttributes> getResult(RestConnection connection, RestRequestBuilder requestBuilder) {
        Result<InputStream, HttpResponseAttributes> result;
        try {
            CompletableFuture<Result<InputStream, HttpResponseAttributes>> requestFuture = connection.request(requestBuilder, Math.toIntExact(this.responseTimeoutTimeUnit.toMillis(this.responseTimeout)), this.defaultMediaType, this.streamingHelper);
            result = requestFuture.get();
        }
        catch (ExecutionException e) {
            logger.error("Could not get Page results", (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException && cause instanceof RequestException) {
                ErrorTypeDefinition type = ((RequestException)((Object)cause)).getType();
                if (type != null && UNAUTHORIZED.equals(type.toString())) {
                    cause = new ConnectionException(cause, (Object)connection);
                } else {
                    throw (RuntimeException)cause;
                }
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)cause.getMessage()), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Interrupted while getting page response"), (Throwable)e);
        }
        return result;
    }

    protected abstract Result onProcessResult(Result var1, JsonNode var2);

    public List<Result> getPage(RestConnection connection) {
        return this.doGetPage(connection);
    }

    private RestRequestBuilder getRequestBuilder(RestConnection connection) {
        if (this.isFirstPage()) {
            return this.requestFactory.apply(connection);
        }
        return this.nextRequestBuilder(connection);
    }

    protected RestRequestBuilder nextRequestBuilder(RestConnection connection) {
        return this.requestFactory.apply(connection);
    }

    public Optional<Integer> getTotalResults(RestConnection connection) {
        return Optional.empty();
    }

    public final void close(RestConnection connection) throws MuleException {
        this.doClose(connection);
    }

    protected abstract void onPage(List<Result> var1, JsonNode var2, HttpResponseAttributes var3);

    protected void stopPaging() {
        this.stopPaging = true;
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    public void setNextPage() {
        this.firstPage = false;
    }

    protected void doClose(RestConnection connection) {
        connection.disconnect();
    }

    protected List<Result<String, HttpPagedResponseAttributes>> extractPayload(Result result, JsonNode pageJsonNode) {
        Optional<JsonNode> pageElements = Optional.ofNullable(pageJsonNode.get(this.pageableField));
        logger.debug("Payload rest paging: {}", pageElements);
        return RestSdkUtils.toListResult(this.config, (Result<InputStream, HttpPagedResponseAttributes>)result, pageElements);
    }

    private String consumeStringAndClose(InputStream stream, Charset sourceCharset) {
        if (stream == null) {
            return "";
        }
        if (!(stream instanceof InputStream)) {
            throw new IllegalArgumentException("Cannot consume stream of unsupported type: " + stream.getClass().getName());
        }
        Either content = Either.right((Object)stream);
        return (String)content.reduce(provider -> {
            try {
                String string = this.doConsumeAndClose((InputStream)provider.openCursor(), sourceCharset);
                return string;
            }
            finally {
                IOUtils.closeQuietly((Closeable)stream);
                this.closeAndRelease((CursorProvider<?>)provider);
            }
        }, in -> this.doConsumeAndClose((InputStream)in, sourceCharset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doConsumeAndClose(InputStream stream, Charset sourceCharset) {
        try {
            String string = IOUtils.toString((InputStream)stream, (Charset)sourceCharset);
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    private void closeAndRelease(CursorProvider<?> cursorProvider) {
        cursorProvider.close();
        cursorProvider.releaseResources();
    }
}

