/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.service.paging;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.Gson;
import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.RestConstants;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.params.QueryRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.service.paging.RestPagingProvider;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPagingProvider
extends RestPagingProvider {
    private static final Logger logger = LoggerFactory.getLogger(QueryPagingProvider.class);
    public static final String PAGE_TOKEN = "pageToken";
    public static final String ROWS = "rows";
    private final String markerParamName;
    private final String nextMarkerField;
    private Function<RestConnection, RestRequestBuilder> nextRequestFactory;
    private boolean firstPage = true;
    private String nextMarker;
    private String maxResults;
    private String nextJobId;
    private QueryRequestParameters requestHelper;

    public QueryPagingProvider(RestConfiguration config, Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper, MediaType defaultMediaType, int responseTimeout, TimeUnit responseTimeoutUnit, QueryRequestParameters requestHelper) {
        super(config, requestFactory, expressionLanguage, streamingHelper, ROWS, defaultMediaType, responseTimeout, responseTimeoutUnit);
        this.markerParamName = PAGE_TOKEN;
        this.nextMarkerField = PAGE_TOKEN;
        this.requestHelper = requestHelper;
        this.maxResults = requestHelper.getMaxResults();
    }

    @Override
    protected void configureRequest(RestRequestBuilder requestBuilder) {
        if (!this.firstPage && StringUtils.isBlank((CharSequence)this.nextMarker)) {
            this.stopPaging();
            return;
        }
        requestBuilder.addQueryParam("maxResults", this.maxResults != null ? this.maxResults : null);
        requestBuilder.addQueryParam(this.markerParamName, this.nextMarker != null ? this.nextMarker : null);
    }

    @Override
    protected Result onProcessResult(Result result, JsonNode rawResultJsonNode) {
        return this.setTableInAttributes(result, rawResultJsonNode);
    }

    @Override
    protected RestRequestBuilder nextRequestBuilder(RestConnection connection) {
        if (this.nextRequestFactory == null) {
            this.nextRequestFactory = this.generateNewRequestBuilder();
        }
        return this.nextRequestFactory.apply(connection);
    }

    private Function<RestConnection, RestRequestBuilder> generateNewRequestBuilder() {
        return connection -> {
            String requestPath = this.buildRequestPath("projects/{projectId}/queries/{jobId}", connection.getProjectId(), this.nextJobId);
            return new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, this.requestHelper.getParameters()).setQueryParamFormat(RestConstants.QUERY_PARAM_FORMAT).addHeader("accept", "application/json").addHeader("content-type", "application/json");
        };
    }

    @Override
    public List<Result> getPage(RestConnection connection) {
        return this.doGetPage(connection);
    }

    @Override
    protected void onPage(List<Result> page, JsonNode rawPage, HttpResponseAttributes httpResponseAttributes) {
        this.firstPage = false;
        if (!rawPage.has(this.nextMarkerField)) {
            this.stopPaging();
        } else if (rawPage.get(this.nextMarkerField).isTextual()) {
            logger.debug("Values of MaxResults: {} , nextMarker: {} , nextJobId: {} ", new Object[]{this.maxResults, this.nextMarker, this.nextJobId});
            this.nextJobId = this.getValueFromMap(rawPage, this.requestHelper.getJobReference().split("\\."));
            this.nextMarker = rawPage.get(this.nextMarkerField).asText();
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The next marker field values must be and string"));
        }
    }

    private String getValueFromMap(JsonNode jsonNode, String[] valuesKeys) {
        Map map = (Map)new Gson().fromJson(jsonNode.get(valuesKeys[0]).toString(), Map.class);
        return (String)map.get(valuesKeys[1]);
    }

    private String buildRequestPath(String mainData, String projectId, String jobId) {
        return this.replaceMatcher(this.replaceMatcher(mainData, RestConstants.BIGQUERY_PROJECT_ID_PATTERN, projectId), RestConstants.BIGQUERY_JOB_ID_PATTERN, jobId);
    }

    private String replaceMatcher(String mainData, Pattern pattern, String data) {
        return pattern.matcher(mainData).replaceAll(data);
    }
}

