/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.service.paging;

import com.fasterxml.jackson.databind.JsonNode;
import com.mulesoft.connectors.google.bigquery.api.param.HttpPagedResponseAttributes;
import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.params.QueryRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.service.paging.QueryPagingProvider;
import com.mulesoft.connectors.google.bigquery.internal.util.ObjectMapperTransformations;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnTableRowQueryPagingProvider
extends QueryPagingProvider {
    private static final Logger logger = LoggerFactory.getLogger(OnTableRowQueryPagingProvider.class);

    public OnTableRowQueryPagingProvider(RestConfiguration config, Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper, MediaType defaultMediaType, int responseTimeout, TimeUnit responseTimeoutTimeUnit, QueryRequestParameters requestHelper) {
        super(config, requestFactory, expressionLanguage, streamingHelper, defaultMediaType, responseTimeout, responseTimeoutTimeUnit, requestHelper);
    }

    @Override
    protected List<Result<String, HttpPagedResponseAttributes>> extractPayload(Result result, JsonNode pageJsonNode) {
        JsonNode pageElements = pageJsonNode.get("rows");
        logger.debug("Payload : {}", (Object)pageElements);
        if (pageElements == null) {
            logger.debug("There are no rows in the result");
            return Collections.emptyList();
        }
        if (pageElements.isArray()) {
            return ObjectMapperTransformations.replaceResponseKeysForSchemaFieldNames((Result<InputStream, HttpResponseAttributes>)result, pageJsonNode, pageElements);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The result does no contain the expected json node array type, it was %s", (Object[])new Object[]{pageElements.getNodeType()}));
    }
}

