/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.service.paging;

import com.fasterxml.jackson.databind.JsonNode;
import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.service.paging.RestPagingProvider;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class ListJobsPagingProvider
extends RestPagingProvider {
    public static final String PAGE_TOKEN = "pageToken";
    public static final String NEXT_PAGE_TOKEN = "nextPageToken";
    public static final String JOBS = "jobs";
    private final String markerParamName;
    private final String nextMarkerField;
    private boolean firstPage = true;
    private String nextMarker;

    public ListJobsPagingProvider(RestConfiguration config, Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, StreamingHelper streamingHelper, MediaType defaultMediaType, int responseTimeout, TimeUnit responseTimeoutTimeUnit) {
        super(config, requestFactory, expressionLanguage, streamingHelper, JOBS, defaultMediaType, responseTimeout, responseTimeoutTimeUnit);
        this.markerParamName = PAGE_TOKEN;
        this.nextMarkerField = NEXT_PAGE_TOKEN;
    }

    @Override
    protected void configureRequest(RestRequestBuilder requestBuilder) {
        if (!this.firstPage && StringUtils.isBlank((CharSequence)this.nextMarker)) {
            this.stopPaging();
            return;
        }
        requestBuilder.addQueryParam(this.markerParamName, this.nextMarker);
    }

    @Override
    protected Result onProcessResult(Result result, JsonNode rawResultJsonNode) {
        return result;
    }

    @Override
    protected void onPage(List<Result> page, JsonNode rawPage, HttpResponseAttributes responseAttributes) {
        this.firstPage = false;
        if (!rawPage.has(this.nextMarkerField)) {
            this.stopPaging();
        } else if (rawPage.get(this.nextMarkerField).isTextual()) {
            this.nextMarker = rawPage.get(this.nextMarkerField).asText();
        } else {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The next marker field values must be and string"));
        }
    }
}

