/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.params;

import org.apache.commons.text.StringEscapeUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class OnTableRowParameterGroup {
    @Parameter
    @Summary(value="The name of the dataset to listen new rows")
    @Example(value="bigquery-dataset")
    @MetadataKeyPart(order=1)
    private String datasetName;
    @Parameter
    @Summary(value="The name of the table to listen new rows")
    @Example(value="users")
    @MetadataKeyPart(order=2)
    private String tableName;
    @Parameter
    @Summary(value="The name of the column used for watermark")
    @Example(value="date_column")
    @Optional
    private String watermarkColumn;
    @Parameter
    @Summary(value="A DW expression corresponding to a Java Serializable type. E.g. : String, Long, etc. This value determines the initial filtering of the watermark column.")
    @Example(value="#['2022-01-01']")
    @Optional
    private String since;
    @Parameter
    @Summary(value="The name of the column to consider as row Id")
    @Optional
    private String columnId;

    public OnTableRowParameterGroup() {
    }

    public OnTableRowParameterGroup(String datasetName, String tableName, String watermarkColumn, String columnId, String since) {
        this.datasetName = datasetName;
        this.tableName = tableName;
        this.watermarkColumn = watermarkColumn;
        this.columnId = columnId;
        this.since = since;
    }

    public String getTableName() {
        return StringEscapeUtils.escapeJava((String)this.tableName);
    }

    public String getWatermarkColumn() {
        return StringEscapeUtils.escapeJava((String)this.watermarkColumn);
    }

    public String getColumnId() {
        return StringEscapeUtils.escapeJava((String)this.columnId);
    }

    public String getSince() {
        return this.since;
    }

    public String getDatasetName() {
        return StringEscapeUtils.escapeJava((String)this.datasetName);
    }
}

