/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.operation;

import com.google.gson.Gson;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.ConfigurationOverrides;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.error.provider.BigQueryErrorTypeProvider;
import com.mulesoft.connectors.google.bigquery.internal.metadata.input.QueryInputMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.metadata.paging.AttributesPagingMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.metadata.paging.QueryPagingMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.operation.BaseRestOperation;
import com.mulesoft.connectors.google.bigquery.internal.params.NonEntityRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.params.QueryRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.service.paging.QueryPagingProvider;
import com.mulesoft.connectors.google.bigquery.internal.util.RequestBuilderCreator;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPagedOperation
extends BaseRestOperation {
    private static final Logger logger = LoggerFactory.getLogger(QueryPagedOperation.class);
    public static final String JOB_REFERENCE_JOB_ID = "jobReference.jobId";
    public static final String MAX_RESULTS = "maxResults";
    @Inject
    private ExpressionLanguage expressionLanguage;

    public QueryPagedOperation() {
    }

    public QueryPagedOperation(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    @Throws(value={BigQueryErrorTypeProvider.class})
    @DisplayName(value="Query")
    @OutputResolver(output=QueryPagingMetadataResolver.class, attributes=AttributesPagingMetadataResolver.class)
    public PagingProvider<RestConnection, Result> query(@Config RestConfiguration config, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @Content @TypeResolver(value=QueryInputMetadataResolver.class) TypedValue<InputStream> queryValuesContent, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper) {
        String maxResults = "20";
        TypedValue queryValuesContentCopy = null;
        try {
            logger.info("Query value content : {}", queryValuesContent.getValue());
            Map resultMap = (Map)new Gson().fromJson(IOUtils.toString((InputStream)((InputStream)queryValuesContent.getValue()), (Charset)StandardCharsets.UTF_8), Map.class);
            if (resultMap.containsKey(MAX_RESULTS)) {
                maxResults = (String)resultMap.get(MAX_RESULTS);
                queryValuesContentCopy = queryValuesContent;
            } else {
                resultMap.put(MAX_RESULTS, maxResults);
                DataType dataType = DataType.builder().type(InputStream.class).build();
                queryValuesContentCopy = new TypedValue((Object)IOUtils.toInputStream((String)new Gson().toJson((Object)resultMap), (Charset)Charset.defaultCharset()), dataType);
            }
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error when parsing the query json content for the operation", (Object[])new Object[]{e}));
        }
        Function<RestConnection, RestRequestBuilder> requestFactory = RequestBuilderCreator.queryRequestBuilderFunction(queryValuesContentCopy, parameters, overrides);
        logger.debug("Query Results Params: {} ", requestFactory);
        return new QueryPagingProvider(config, requestFactory, this.expressionLanguage, streamingHelper, this.resolveDefaultResponseMediaType(config), overrides.getResponseTimeout(), overrides.getResponseTimeoutUnit(), new QueryRequestParameters(JOB_REFERENCE_JOB_ID, parameters, overrides, maxResults));
    }
}

