/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.operation;

import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.ConfigurationOverrides;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.error.provider.BigQueryErrorTypeProvider;
import com.mulesoft.connectors.google.bigquery.internal.metadata.paging.ListJobsPagingMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.operation.BaseRestOperation;
import com.mulesoft.connectors.google.bigquery.internal.params.NonEntityRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.service.paging.ListJobsPagingProvider;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListJobsPagedOperation
extends BaseRestOperation {
    private static final Logger logger = LoggerFactory.getLogger(ListJobsPagedOperation.class);
    public static final String JOB_PATH = "/projects/{projectId}/jobs";
    private static final Pattern BIGQUERY_PROJECT_ID_PATTERN = Pattern.compile("\\{projectId}");
    @Inject
    private ExpressionLanguage expressionLanguage;

    @Throws(value={BigQueryErrorTypeProvider.class})
    @DisplayName(value="List Jobs")
    @OutputResolver(output=ListJobsPagingMetadataResolver.class)
    public ListJobsPagingProvider listJobs(@Config RestConfiguration config, @Optional(defaultValue="application/json") @DisplayName(value="Content Type") String contentType, @Optional(defaultValue="30") @DisplayName(value="Max Results") @Summary(value="The maximum number of comments to return per page.") Integer maxResults, @Optional @DisplayName(value="Pretty Print") @Summary(value="Returns the response with indentations and line breaks.") boolean prettyPrint, @Optional @DisplayName(value="Page Token") @Summary(value="The token for continuing a previous list request on the next page.") String pageToken, @Optional @DisplayName(value="Quota User") @Summary(value="An opaque string that represents a user for quota purposes. Must not exceed 40 characters.") String quotaUser, @Optional @DisplayName(value="User Ip") @Summary(value="Deprecated. Use quotaUser instead.") String userIp, @Optional @DisplayName(value="fields") @Summary(value="Selector specifying which fields to include in a partial response.") String fields, @Optional @DisplayName(value="Min Created Time") @Summary(value="Min value for job creation time, in milliseconds since the POSIX epoch. (RFC 3339 date-time).") String minCreationTime, @Optional @DisplayName(value="Max Created Time") @Summary(value="Max value for job creation time, in milliseconds since the POSIX epoch. (RFC 3339 date-time).") String maxCreationTime, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper) {
        Function<RestConnection, RestRequestBuilder> requestFactory = connection -> {
            String requestPath = this.buildRequestPath(JOB_PATH, connection.getProjectId());
            return new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(RestRequestBuilder.QueryParamFormat.MULTIMAP).addHeader("accept", "application/json").addHeader("content-type", "application/json").addQueryParam("maxResults", maxResults != null ? String.valueOf(maxResults) : null).addQueryParam("prettyPrint", String.valueOf(prettyPrint)).addQueryParam("quotaUser", quotaUser).addQueryParam("userIp", userIp).addQueryParam("pageToken", pageToken).addQueryParam("fields", fields).addQueryParam("minCreationTime", minCreationTime).addQueryParam("maxCreationTime", maxCreationTime);
        };
        logger.debug("Query params Params: {} ", requestFactory);
        return new ListJobsPagingProvider(config, requestFactory, this.expressionLanguage, streamingHelper, this.resolveDefaultResponseMediaType(config), overrides.getResponseTimeout(), overrides.getResponseTimeoutUnit());
    }

    private String buildRequestPath(String mainData, String projectId) {
        return this.replaceMatcher(mainData, BIGQUERY_PROJECT_ID_PATTERN, projectId);
    }

    private String replaceMatcher(String mainData, Pattern pattern, String data) {
        return pattern.matcher(mainData).replaceAll(data);
    }
}

