/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.operation;

import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.ConfigurationOverrides;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.error.provider.BigQueryErrorTypeProvider;
import com.mulesoft.connectors.google.bigquery.internal.metadata.input.InsertJobInputMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.metadata.output.CancelJobOutputMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.metadata.output.GetJobOutputMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.metadata.output.InsertJobOutputMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.operation.BaseRestOperation;
import com.mulesoft.connectors.google.bigquery.internal.params.NonEntityRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobOperation
extends BaseRestOperation {
    private static final Logger logger = LoggerFactory.getLogger(JobOperation.class);
    private static final Pattern BIGQUERY_PROJECT_ID_PATTERN = Pattern.compile("\\{projectId}");
    private static final Pattern BIGQUERY_JOB_ID_PATTERN = Pattern.compile("\\{jobId}");

    @Throws(value={BigQueryErrorTypeProvider.class})
    @DisplayName(value="Get Job")
    @MediaType(value="application/json")
    @OutputResolver(output=GetJobOutputMetadataResolver.class)
    public void getJob(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Job Id") String jobId, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        logger.trace("Retrieving job Id : {} in project with Id: {}", (Object)jobId, (Object)connection.getProjectId());
        this.doRequest(config, connection, this.restRequestBuilder(connection.getBaseUri(), this.buildRequestPath("/projects/{projectId}/jobs/{jobId}", connection.getProjectId(), jobId), HttpConstants.Method.GET, parameters), overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }

    @Throws(value={BigQueryErrorTypeProvider.class})
    @DisplayName(value="Insert Job")
    @MediaType(value="application/json")
    @OutputResolver(output=InsertJobOutputMetadataResolver.class)
    public void insertJob(@Config RestConfiguration config, @Connection RestConnection connection, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @Content @TypeResolver(value=InsertJobInputMetadataResolver.class) TypedValue<InputStream> jobValuesContent, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        logger.trace("Insert job in project with Id: {}", (Object)connection.getProjectId());
        this.doRequest(config, connection, this.postRestRequestBuilder(connection.getBaseUri(), this.buildRequestPath("/projects/{projectId}/jobs", connection.getProjectId()), HttpConstants.Method.POST, parameters, jobValuesContent, overrides), overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }

    @Throws(value={BigQueryErrorTypeProvider.class})
    @MediaType(value="application/json")
    @DisplayName(value="Delete Job")
    public void deleteJob(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Job Id") String jobId, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<Void, HttpResponseAttributes> callback) {
        logger.debug("Delete job in project with Id: {} and jobId: {}", (Object)connection.getProjectId(), (Object)jobId);
        this.doVoidRequest(connection, this.restRequestBuilder(connection.getBaseUri(), this.buildRequestPath("/projects/{projectId}/jobs/{jobId}/delete", connection.getProjectId(), jobId), HttpConstants.Method.DELETE, parameters), overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }

    @Throws(value={BigQueryErrorTypeProvider.class})
    @DisplayName(value="Cancel Job")
    @MediaType(value="application/json")
    @OutputResolver(output=CancelJobOutputMetadataResolver.class)
    public void cancelJob(@Config RestConfiguration config, @Connection RestConnection connection, @DisplayName(value="Job Id") String jobId, @Optional(defaultValue="application/json") @DisplayName(value="Content Type") String contentType, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        logger.trace("Cancel job in project with Id: {} and jobId: {}", (Object)connection.getProjectId(), (Object)jobId);
        this.doRequest(config, connection, this.restRequestBuilder(connection.getBaseUri(), this.buildRequestPath("/projects/{projectId}/jobs/{jobId}/cancel", connection.getProjectId(), jobId), HttpConstants.Method.POST, parameters), overrides.getResponseTimeoutAsMillis(), streamingHelper, callback);
    }

    private RestRequestBuilder postRestRequestBuilder(String uri, String path, HttpConstants.Method method, NonEntityRequestParameters parameters, TypedValue<InputStream> jobValuesContent, ConfigurationOverrides overrides) {
        return this.restRequestBuilder(uri, path, method, parameters).setBody(jobValuesContent, overrides.getStreamingType());
    }

    private String buildRequestPath(String mainData, String projectId, String jobId) {
        return this.buildRequestPath(this.replaceMatcher(mainData, BIGQUERY_JOB_ID_PATTERN, jobId), projectId);
    }

    private RestRequestBuilder restRequestBuilder(String uri, String path, HttpConstants.Method method, NonEntityRequestParameters parameters) {
        return new RestRequestBuilder(uri, path, method, parameters).setQueryParamFormat(RestRequestBuilder.QueryParamFormat.MULTIMAP).addHeader("accept", "application/json").addHeader("content-type", "application/json");
    }

    private String buildRequestPath(String mainData, String projectId) {
        return this.replaceMatcher(mainData, BIGQUERY_PROJECT_ID_PATTERN, projectId);
    }

    private String replaceMatcher(String mainData, Pattern pattern, String data) {
        return pattern.matcher(mainData).replaceAll(data);
    }
}

