/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.operation;

import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.ConfigurationOverrides;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.error.provider.BigQueryErrorTypeProvider;
import com.mulesoft.connectors.google.bigquery.internal.metadata.paging.AttributesPagingMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.metadata.paging.QueryResultPagingMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.operation.BaseRestOperation;
import com.mulesoft.connectors.google.bigquery.internal.params.NonEntityRequestParameters;
import com.mulesoft.connectors.google.bigquery.internal.service.paging.QueryResultPagingProvider;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetQueryResultsPagedOperation
extends BaseRestOperation {
    private static final Logger logger = LoggerFactory.getLogger(GetQueryResultsPagedOperation.class);
    public static final String GET_RESULT_JOB_PATH = "projects/{projectId}/queries/{jobId}";
    private static final Pattern BIGQUERY_PROJECT_ID_PATTERN = Pattern.compile("\\{projectId}");
    private static final Pattern BIGQUERY_JOB_ID_PATTERN = Pattern.compile("\\{jobId}");
    @Inject
    private ExpressionLanguage expressionLanguage;

    @Throws(value={BigQueryErrorTypeProvider.class})
    @DisplayName(value="Get Query Results")
    @OutputResolver(output=QueryResultPagingMetadataResolver.class, attributes=AttributesPagingMetadataResolver.class)
    public QueryResultPagingProvider getQueryResults(@Config RestConfiguration config, @Optional @DisplayName(value="Job Id") String jobId, @Optional(defaultValue="0") @DisplayName(value="Start Index") @Summary(value="Zero-based index of the starting row.") Integer startIndex, @Optional(defaultValue="30") @DisplayName(value="Max Results") @Summary(value="The maximum number of comments to return per page.") Integer maxResults, @Optional @DisplayName(value="Page Token") @Summary(value="The token for continuing a previous list request on the next page.") String pageToken, @Optional @DisplayName(value="Location") @Summary(value="The geographic location of the job.") String location, @Optional @DisplayName(value="Time out") @Summary(value="Specifies the maximum amount of time, in milliseconds, to wait for the query to complete.") String timeoutMs, @ParameterGroup(name="Request Parameters") NonEntityRequestParameters parameters, @ParameterGroup(name="Connector Overrides") ConfigurationOverrides overrides, StreamingHelper streamingHelper) {
        Function<RestConnection, RestRequestBuilder> requestFactory = connection -> {
            String requestPath = this.buildRequestPath(GET_RESULT_JOB_PATH, connection.getProjectId(), jobId);
            return new RestRequestBuilder(connection.getBaseUri(), requestPath, HttpConstants.Method.GET, parameters).setQueryParamFormat(RestRequestBuilder.QueryParamFormat.MULTIMAP).addHeader("accept", "application/json").addHeader("content-type", "application/json").addQueryParam("startIndex", startIndex != null ? String.valueOf(startIndex) : null).addQueryParam("maxResults", maxResults != null ? String.valueOf(maxResults) : null).addQueryParam("timeoutMs", timeoutMs).addQueryParam("location", location).addQueryParam("pageToken", pageToken);
        };
        logger.info("Query Results Params: {} ", requestFactory);
        return new QueryResultPagingProvider(config, requestFactory, this.expressionLanguage, streamingHelper, this.resolveDefaultResponseMediaType(config), overrides.getResponseTimeout(), overrides.getResponseTimeoutUnit());
    }

    private String buildRequestPath(String mainData, String projectId, String jobId) {
        return this.replaceMatcher(this.replaceMatcher(mainData, BIGQUERY_PROJECT_ID_PATTERN, projectId), BIGQUERY_JOB_ID_PATTERN, jobId);
    }

    private String replaceMatcher(String mainData, Pattern pattern, String data) {
        return pattern.matcher(mainData).replaceAll(data);
    }
}

