/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.operation;

import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.io.InputStream;
import java.util.function.BiConsumer;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public abstract class BaseRestOperation {
    protected BaseRestOperation() {
    }

    protected void doRequest(RestConfiguration config, RestConnection connection, RestRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        try {
            connection.request(builder, responseTimeoutMillis, this.resolveDefaultResponseMediaType(config), streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    protected MediaType resolveDefaultResponseMediaType(RestConfiguration config) {
        MediaType mediaType = this.getDefaultResponseMediaType();
        if (!mediaType.getCharset().isPresent()) {
            mediaType = mediaType.withCharset(config.getCharset());
        }
        return mediaType;
    }

    protected void doVoidRequest(RestConnection connection, RestRequestBuilder builder, int responseTimeoutMillis, StreamingHelper streamingHelper, CompletionCallback<Void, HttpResponseAttributes> callback) {
        try {
            connection.bodylessRequest(builder, responseTimeoutMillis, MediaType.ANY, streamingHelper).whenComplete((BiConsumer)this.handleResponse(callback));
        }
        catch (Exception e) {
            callback.error((Throwable)e);
        }
    }

    private <T> BiConsumer<Result<T, HttpResponseAttributes>, Throwable> handleResponse(CompletionCallback<T, HttpResponseAttributes> callback) {
        return (result, error) -> {
            if (error != null) {
                callback.error(error);
            } else {
                callback.success(result);
            }
        };
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

