/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.metadata.output;

import com.fasterxml.jackson.databind.JsonNode;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.metadata.DataTypeMapping;
import com.mulesoft.connectors.google.bigquery.internal.metadata.keys.AbstractMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.params.OnTableRowParameterGroup;
import com.mulesoft.connectors.google.bigquery.internal.util.BigQueryEndpoints;
import com.mulesoft.connectors.google.bigquery.internal.util.ObjectMapperTransformations;
import com.mulesoft.connectors.google.bigquery.internal.util.QueryHelper;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnTableRowOutputMetadataResolver
extends AbstractMetadataResolver
implements OutputTypeResolver<OnTableRowParameterGroup> {
    private static final Logger logger = LoggerFactory.getLogger(OnTableRowOutputMetadataResolver.class);
    public static final String COLUMN_NAME = "column_name";
    public static final String DESCRIPTION = "description";
    public static final String DATA_TYPE = "data_type";

    @Override
    public String getResolverName() {
        return "row-listener-output-metadata-resolver";
    }

    public String getCategoryName() {
        return "source";
    }

    public MetadataType getOutputType(MetadataContext metadataContext, OnTableRowParameterGroup onTableRowParameterGroup) throws MetadataResolvingException, ConnectionException {
        return this.getOutputMetadata(metadataContext, onTableRowParameterGroup);
    }

    private MetadataType getOutputMetadata(MetadataContext metadataContext, OnTableRowParameterGroup onTableRowParameterGroup) throws MetadataResolvingException, ConnectionException {
        RestConfiguration config = this.getConfig(metadataContext);
        RestConnection connection = this.getConnection(metadataContext);
        if (onTableRowParameterGroup.getDatasetName() == null || onTableRowParameterGroup.getTableName() == null) {
            throw new MetadataResolvingException("No Metadata available for an empty datasetName or tableName", FailureCode.INVALID_METADATA_KEY);
        }
        return this.createMetadataTypeObjectFromFieldNames(this.requestFieldNames(config, connection, onTableRowParameterGroup));
    }

    private List<Map<String, Object>> requestFieldNames(RestConfiguration config, RestConnection connection, OnTableRowParameterGroup onTableRowParameterGroup) {
        TypedValue<InputStream> query = QueryHelper.getTableSchemaInformationQuery(onTableRowParameterGroup.getDatasetName(), onTableRowParameterGroup.getTableName());
        JsonNode tableSchemaInformationResponse = connection.createRequestAsJsonNode(BigQueryEndpoints.getRequestPathForQueriesOperation(connection.getBaseUri(), connection.getProjectId()), "/", HttpConstants.Method.POST, query, config);
        logger.debug("Table Schema Information = {}", (Object)tableSchemaInformationResponse);
        return ObjectMapperTransformations.replaceResponseKeysForSchemaFieldNames(tableSchemaInformationResponse);
    }

    private ObjectType createMetadataTypeObjectFromFieldNames(List<Map<String, Object>> fields) {
        ObjectTypeBuilder object = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).objectType();
        fields.forEach(fieldName -> {
            logger.debug("Metadata incoming field = {}", fieldName);
            ObjectFieldTypeBuilder objectFieldTypeBuilder = object.addField().key((String)fieldName.get(COLUMN_NAME)).description((String)fieldName.get(DESCRIPTION));
            this.resolveDataType(objectFieldTypeBuilder, (String)fieldName.get(DATA_TYPE));
            objectFieldTypeBuilder.build();
        });
        return object.build();
    }

    private void resolveDataType(ObjectFieldTypeBuilder object, String type) {
        try {
            MetadataType metadataType = DataTypeMapping.DataTypes.valueOf(type).getTypeBuilder();
            if (metadataType != null) {
                object.value(metadataType);
            }
        }
        catch (IllegalArgumentException e) {
            object.value().objectType();
        }
    }
}

