/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.metadata.keys;

import com.fasterxml.jackson.databind.JsonNode;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.metadata.keys.AbstractMetadataResolver;
import com.mulesoft.connectors.google.bigquery.internal.util.BigQueryEndpoints;
import com.mulesoft.connectors.google.bigquery.internal.util.QueryHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnTableRowKeysResolver
extends AbstractMetadataResolver
implements TypeKeysResolver {
    private static final Logger logger = LoggerFactory.getLogger(OnTableRowKeysResolver.class);

    public String getCategoryName() {
        return "source";
    }

    @Override
    public String getResolverName() {
        return "row-listener-key-resolver";
    }

    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        HashSet<MetadataKey> metadataKeys = new HashSet<MetadataKey>();
        for (String datasetName : this.getDatasetNames(this.getConnection(metadataContext), this.getConfig(metadataContext))) {
            MetadataKeyBuilder metadataKey = MetadataKeyBuilder.newKey((String)datasetName);
            for (String tableName : this.getTableNames(this.getConnection(metadataContext), this.getConfig(metadataContext), datasetName)) {
                metadataKey.withChild(MetadataKeyBuilder.newKey((String)tableName));
            }
            metadataKeys.add(metadataKey.build());
        }
        return metadataKeys;
    }

    private List<String> getTableNames(RestConnection connection, RestConfiguration config, String datasetName) {
        JsonNode responseAsJsonNode = connection.createRequestAsJsonNode(BigQueryEndpoints.getRequestPathForTablesOperation(connection.getBaseUri(), connection.getProjectId(), datasetName), "/", HttpConstants.Method.GET, null, config);
        ArrayList<String> tablesNames = new ArrayList<String>();
        if (responseAsJsonNode.get("totalItems").asInt() > 0) {
            responseAsJsonNode.get("tables").forEach(t -> tablesNames.add(t.get("tableReference").get("tableId").asText()));
            logger.debug("tableNames = {}", tablesNames);
            return tablesNames;
        }
        return Collections.emptyList();
    }

    private List<String> getDatasetNames(RestConnection connection, RestConfiguration config) {
        JsonNode responseAsJsonNode = connection.createRequestAsJsonNode(BigQueryEndpoints.getRequestPathForQueriesOperation(connection.getBaseUri(), connection.getProjectId()), "/", HttpConstants.Method.POST, QueryHelper.getDatasetsQueryPayload(connection.getProjectId()), config);
        ArrayList<String> datasetsNames = new ArrayList<String>();
        if (responseAsJsonNode.get("totalRows").asInt() > 0) {
            responseAsJsonNode.get("rows").iterator().forEachRemaining(r -> datasetsNames.add(r.get("f").get(0).get("v").asText()));
            logger.debug("datasetNames = {}", datasetsNames);
            return datasetsNames;
        }
        return Collections.emptyList();
    }
}

