/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.error.exception;

import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.error.RestErrorType;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class RequestException
extends ModuleException
implements ErrorMessageAwareException {
    private final Message message;

    public RequestException(RestErrorType error, Result<Object, HttpResponseAttributes> response) {
        super("Request returned status code " + ((HttpResponseAttributes)response.getAttributes().get()).getStatusCode(), (ErrorTypeDefinition)error);
        Message.Builder builder = Message.builder().payload(this.getPayloadTypedValue(response)).mediaType(this.getMediaType(response));
        this.setAttributes(response, builder);
        this.message = builder.build();
    }

    private TypedValue<Object> getPayloadTypedValue(Result<Object, HttpResponseAttributes> response) {
        DataType dataType = DataType.builder().type(response.getOutput().getClass()).mediaType(this.getMediaType(response)).build();
        return new TypedValue(response.getOutput(), dataType, response.getByteLength());
    }

    private void setAttributes(Result<Object, HttpResponseAttributes> response, Message.Builder builder) {
        response.getAttributes().ifPresent(attributes -> {
            DataType dataType = DataType.builder().type(attributes.getClass()).mediaType(response.getAttributesMediaType().orElse(MediaType.APPLICATION_JAVA)).build();
            builder.attributes(new TypedValue(attributes, dataType));
        });
    }

    private MediaType getMediaType(Result<Object, HttpResponseAttributes> response) {
        return response.getMediaType().orElse(null);
    }

    public Message getErrorMessage() {
        return this.message;
    }
}

