/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.error;

import java.util.Optional;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RestErrorType implements ErrorTypeDefinition<RestErrorType>
{
    CONNECTIVITY((ErrorTypeDefinition<? extends Enum<?>>)MuleErrors.CONNECTIVITY),
    CLIENT_ERROR,
    BAD_REQUEST(CLIENT_ERROR),
    NOT_FOUND(CLIENT_ERROR),
    SERVER_ERROR,
    INTERNAL_SERVER_ERROR(SERVER_ERROR),
    TIMEOUT(CLIENT_ERROR),
    UNAUTHORIZED(CLIENT_ERROR),
    PROJECT_NOT_FOUND;

    private static final Logger LOGGER;
    private ErrorTypeDefinition<? extends Enum<?>> parent;

    private RestErrorType() {
    }

    private RestErrorType(ErrorTypeDefinition<? extends Enum<?>> parent) {
        this.parent = parent;
    }

    public static Optional<RestErrorType> getErrorByCode(int statusCode) {
        RestErrorType error = null;
        HttpConstants.HttpStatus status = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
        if (status != null && statusCode >= 400) {
            try {
                error = RestErrorType.valueOf(status.name());
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Invalid status code {}", (Object)status);
            }
        }
        if (error == null) {
            if (statusCode >= 400 && statusCode < 500) {
                error = CLIENT_ERROR;
            } else if (statusCode >= 500) {
                error = SERVER_ERROR;
            }
        }
        return Optional.ofNullable(error);
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    static {
        LOGGER = LoggerFactory.getLogger(RestErrorType.class);
    }
}

