/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection.token;

import com.mulesoft.connectors.google.bigquery.internal.connection.token.ExpirableToken;
import com.mulesoft.connectors.google.bigquery.internal.connection.token.ExpirableTokenContext;
import com.mulesoft.connectors.google.bigquery.internal.connection.token.Provider;
import com.mulesoft.connectors.google.bigquery.internal.connection.token.TokenGenerator;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.mule.runtime.api.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenProvider
implements Provider<ExpirableToken<String>> {
    private static final Logger logger = LoggerFactory.getLogger(TokenProvider.class);
    public static final int AMOUNT_OF_QUEUED_TOKENS = 3;
    private static final int DEFAULT_TIME_OVERLAP_IN_SECONDS_BETWEEN_TOKENS = 10;
    private Scheduler scheduler;
    private final long expirationInterval;
    private final TimeUnit expirationIntervalTimeUnit;
    private ScheduledFuture<?> scheduledFuture;
    private TokenGenerator<ExpirableTokenContext> tokenGenerator;
    private AtomicReference<ExpirableToken<String>> currentToken = new AtomicReference();
    private final Queue<ExpirableToken<String>> expirableTokensQueue = new ArrayBlockingQueue<ExpirableToken<String>>(3);

    public TokenProvider(TokenGenerator<ExpirableTokenContext> tokenGenerator, Scheduler scheduler, long expirationInterval, TimeUnit expirationIntervalTimeUnit) {
        this.tokenGenerator = tokenGenerator;
        this.scheduler = scheduler;
        this.expirationInterval = expirationInterval;
        this.expirationIntervalTimeUnit = expirationIntervalTimeUnit;
        this.ensureEnoughTokensAreGenerated();
        this.rotateTokens();
    }

    @Override
    public void start() {
        this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
            logger.debug("Running scheduled task to rotate token");
            this.rotateTokens();
        }, this.expirationInterval, this.expirationInterval, this.expirationIntervalTimeUnit);
    }

    @Override
    public void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    @Override
    public ExpirableToken<String> provide() {
        ExpirableToken<String> expirableToken = this.currentToken.get();
        if (Instant.now().isAfter(expirableToken.getExpiresAt())) {
            this.invalidateToken(expirableToken);
            expirableToken = this.currentToken.get();
        }
        return expirableToken;
    }

    protected synchronized void invalidateToken(ExpirableToken<String> token) {
        if (this.currentToken.get().equals(token)) {
            logger.debug("Invalidating and Rotating token {}", token);
            this.rotateTokens();
        } else {
            logger.debug("Tried to invalidate token {} , that was already invalidated", token);
        }
    }

    protected synchronized void ensureEnoughTokensAreGenerated() {
        Instant now = Instant.now();
        List expiredTokens = this.expirableTokensQueue.stream().filter(t -> t.getExpiresAt().isBefore(now)).collect(Collectors.toList());
        this.expirableTokensQueue.removeAll(expiredTokens);
        int amountOfTokensToCreate = 3 - this.expirableTokensQueue.size();
        Optional<ExpirableToken> oldestToken = this.expirableTokensQueue.stream().max(Comparator.comparing(ExpirableToken::getExpiresAt));
        logger.debug("Going to generate {} tokens", (Object)amountOfTokensToCreate);
        Instant oldestTokenExpiresAt = oldestToken.map(ExpirableToken::getExpiresAt).orElse(now);
        for (int i = 0; i < amountOfTokensToCreate; ++i) {
            ExpirableToken<String> nextToken = this.generateNextToken(oldestTokenExpiresAt);
            this.expirableTokensQueue.add(nextToken);
            oldestTokenExpiresAt = nextToken.getExpiresAt();
        }
        logger.debug("Generated {} tokens", (Object)amountOfTokensToCreate);
    }

    protected synchronized void rotateTokens() {
        this.currentToken.set(this.expirableTokensQueue.poll());
        this.ensureEnoughTokensAreGenerated();
    }

    private Instant decreaseOverlapTime(Instant expiresAt) {
        return expiresAt.minus(10L, ChronoUnit.SECONDS);
    }

    private ExpirableToken<String> generateNextToken(Instant oldestTokenExpiresAt) {
        Instant expiresAt = oldestTokenExpiresAt.plus(this.expirationIntervalTimeUnit.toMillis(this.expirationInterval), ChronoUnit.MILLIS);
        ExpirableTokenContext context = new ExpirableTokenContext(this.decreaseOverlapTime(oldestTokenExpiresAt), expiresAt);
        return new ExpirableToken<String>(context.getIssuedAt(), context.getExpiresAt(), this.tokenGenerator.generate(context));
    }

    protected Queue<ExpirableToken<String>> getExpirableTokensQueue() {
        return this.expirableTokensQueue;
    }
}

