/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection.token;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.mulesoft.connectors.google.bigquery.internal.connection.token.ExpirableTokenContext;
import com.mulesoft.connectors.google.bigquery.internal.connection.token.TokenGenerator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class JWTTokenGenerator
implements TokenGenerator<ExpirableTokenContext> {
    private final Algorithm signAlgorithm;
    private String privateKeyId;
    private String issuer;
    private String subject;
    private String audience;

    public JWTTokenGenerator(String privateKeyId, String issuer, String subject, String audience, String privateKey) {
        this.privateKeyId = privateKeyId;
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience;
        this.signAlgorithm = Algorithm.RSA256(null, (RSAPrivateKey)((RSAPrivateKey)this.privateKeyFromPkcs8(privateKey)));
    }

    @Override
    public String generate(ExpirableTokenContext context) {
        return JWT.create().withKeyId(this.privateKeyId).withIssuer(this.issuer).withSubject(this.subject).withAudience(new String[]{this.audience}).withIssuedAt(Date.from(context.getIssuedAt())).withExpiresAt(Date.from(context.getExpiresAt())).sign(this.signAlgorithm);
    }

    protected PrivateKey privateKeyFromPkcs8(String privateKeyPem) {
        PemReader.Section section;
        String newline = System.getProperty("line.separator");
        StringReader reader = new StringReader(privateKeyPem.replace("   ", newline));
        try {
            section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Cant read the private key."));
        }
        if (section == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Invalid PKCS8 data."));
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"No such algorithm"), (Throwable)noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Invalid private key"), (Throwable)invalidKeySpecException);
        }
    }
}

