/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection.provider;

import com.mulesoft.connectors.google.bigquery.api.param.proxy.HttpProxyConfig;
import com.mulesoft.connectors.google.bigquery.internal.connection.OAuthRestConnection;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.connection.provider.GenericConnectionProvider;
import com.mulesoft.connectors.google.bigquery.internal.params.OptionalTlsParameterGroup;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthParameter;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

@Alias(value="oauth2")
@DisplayName(value="Oauth2 Connection")
@AuthorizationCode(accessTokenUrl="https://oauth2.googleapis.com/token", authorizationUrl="https://accounts.google.com/o/oauth2/auth", defaultScopes="https://www.googleapis.com/auth/bigquery")
public class OauthConnectionProvider
extends GenericConnectionProvider {
    @OAuthParameter
    @Optional(defaultValue="offline")
    private String access_type;
    @OAuthParameter
    @Optional(defaultValue="consent")
    private String prompt;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Optional
    @Summary(value="Refresh token condition.")
    private String refreshTokenCondition;
    private AuthorizationCodeState authorizationCodeState;

    public OauthConnectionProvider() {
    }

    public OauthConnectionProvider(String access_type, String prompt, String refreshTokenCondition, AuthorizationCodeState authorizationCodeState, String projectId, String baseUri, OptionalTlsParameterGroup tlsConfig, String configName, HttpService httpService, ExpressionLanguage expressionLanguage, MultiMap<String, String> defaultHeaders, MultiMap<String, String> defaultQueryParams, Integer connectionTimeout, Integer maxConnections, Integer connectionIdleTimeout, HttpProxyConfig proxyConfig, int responseBufferSize, String appName, HttpAuthentication authentication, HttpClient httpClient) {
        super(projectId, baseUri, tlsConfig, configName, httpService, expressionLanguage, defaultHeaders, defaultQueryParams, connectionTimeout, maxConnections, connectionIdleTimeout, proxyConfig, responseBufferSize, appName, authentication, httpClient);
        this.access_type = access_type;
        this.prompt = prompt;
        this.refreshTokenCondition = refreshTokenCondition;
        this.authorizationCodeState = authorizationCodeState;
    }

    @Override
    protected RestConnection createConnection(HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders) {
        return new OAuthRestConnection(this.getBaseUri(), this.getProjectId(), this.getConfigName(), httpClient, authentication, defaultQueryParams, defaultHeaders, (OAuthState)this.authorizationCodeState, this.authorizationCodeState.getResourceOwnerId(), this.getExpressionLanguage(), this.refreshTokenCondition);
    }

    public static class Builder
    extends GenericConnectionProvider.Builder {
        private String access_type;
        private String prompt;
        private String refreshTokenCondition;
        private AuthorizationCodeState authorizationCodeState;

        public Builder withAccessType(String access_type) {
            this.access_type = access_type;
            return this;
        }

        public Builder withPrompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder withRefreshTokenCondition(String refreshTokenCondition) {
            this.refreshTokenCondition = refreshTokenCondition;
            return this;
        }

        public Builder withAuthorizationCodeState(AuthorizationCodeState authorizationCodeState) {
            this.authorizationCodeState = authorizationCodeState;
            return this;
        }

        public OauthConnectionProvider build() {
            return new OauthConnectionProvider(this.access_type, this.prompt, this.refreshTokenCondition, this.authorizationCodeState, this.projectId, this.baseUri, this.tlsConfig, this.configName, this.httpService, this.expressionLanguage, this.defaultHeaders, this.defaultQueryParams, this.connectionTimeout, this.maxConnections, this.connectionIdleTimeout, this.proxyConfig, this.responseBufferSize, this.appName, this.authentication, this.httpClient);
        }
    }
}

