/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection.provider;

import com.mulesoft.connectors.google.bigquery.api.param.proxy.HttpProxyConfig;
import com.mulesoft.connectors.google.bigquery.internal.connection.JWTConnection;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.connection.provider.GenericConnectionProvider;
import com.mulesoft.connectors.google.bigquery.internal.params.OptionalTlsParameterGroup;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.sdk.api.annotation.semantics.connectivity.Url;

@Alias(value="jwt")
@DisplayName(value="JWT Connection")
public class JWTConnectionProvider
extends GenericConnectionProvider {
    @Parameter
    @Placement(order=4)
    private String privateKeyId;
    @Parameter
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Placement(order=5)
    @Password
    private String privateKey;
    @Parameter
    @Placement(order=6)
    @Password
    private String issuer;
    @Parameter
    @Optional(defaultValue="https://bigquery.googleapis.com/")
    @Placement(order=7)
    @Summary(value="Identifies the authorization server as an intended audience")
    @Url
    private String audienceUrl;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="3600")
    @Placement(tab="Advanced")
    @Summary(value="The timeout for the token.")
    private Integer tokenTimeout;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced")
    @Summary(value="A time unit which qualifies the Token Timeout")
    private TimeUnit tokenTimeoutUnit;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;

    public JWTConnectionProvider() {
        this.tokenTimeoutUnit = TimeUnit.SECONDS;
    }

    public JWTConnectionProvider(String privateKeyId, String privateKey, String issuer, String audienceUrl, Integer tokenTimeout, TimeUnit tokenTimeoutUnit, SchedulerService schedulerService, String projectId, String baseUri, OptionalTlsParameterGroup tlsConfig, String configName, HttpService httpService, ExpressionLanguage expressionLanguage, MultiMap<String, String> defaultHeaders, MultiMap<String, String> defaultQueryParams, Integer connectionTimeout, Integer maxConnections, Integer connectionIdleTimeout, HttpProxyConfig proxyConfig, int responseBufferSize, String appName, HttpAuthentication authentication, HttpClient httpClient) {
        super(projectId, baseUri, tlsConfig, configName, httpService, expressionLanguage, defaultHeaders, defaultQueryParams, connectionTimeout, maxConnections, connectionIdleTimeout, proxyConfig, responseBufferSize, appName, authentication, httpClient);
        this.privateKeyId = privateKeyId;
        this.privateKey = privateKey;
        this.issuer = issuer;
        this.audienceUrl = audienceUrl;
        this.tokenTimeout = tokenTimeout;
        this.tokenTimeoutUnit = tokenTimeoutUnit;
        this.schedulerService = schedulerService;
    }

    @Override
    protected RestConnection createConnection(HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders) {
        return new JWTConnection(this.getHttpClient(), this.scheduler, this.getExpressionLanguage(), this.getDefaultQueryParams(), defaultHeaders, this.getBaseUri(), this.getProjectId(), this.privateKeyId, this.privateKey, this.issuer, this.audienceUrl, this.tokenTimeout, this.tokenTimeoutUnit);
    }

    @Override
    public void start() {
        super.start();
        SchedulerConfig schedulerConfig = SchedulerConfig.config().withName(this.getConfigName() + "-bigquery-connector_jwt-connection_token_refresh");
        this.scheduler = this.schedulerService.ioScheduler(schedulerConfig);
    }

    @Override
    public void stop() {
        super.stop();
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    public static class Builder
    extends GenericConnectionProvider.Builder {
        private String privateKeyId;
        private String privateKey;
        private String issuer;
        private String audienceUrl;
        private Integer tokenTimeout;
        private TimeUnit tokenTimeoutUnit;
        private SchedulerService schedulerService;

        public Builder withPrivateKeyId(String privateKeyId) {
            this.privateKeyId = privateKeyId;
            return this;
        }

        public Builder withPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder withIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder withAudienceUrl(String audienceUrl) {
            this.audienceUrl = audienceUrl;
            return this;
        }

        public Builder withTokenTimeout(Integer tokenTimeout) {
            this.tokenTimeout = tokenTimeout;
            return this;
        }

        public Builder withTokenTimeoutUnit(TimeUnit tokenTimeoutUnit) {
            this.tokenTimeoutUnit = tokenTimeoutUnit;
            return this;
        }

        public Builder withSchedulerService(SchedulerService schedulerService) {
            this.schedulerService = schedulerService;
            return this;
        }

        public JWTConnectionProvider build() {
            return new JWTConnectionProvider(this.privateKeyId, this.privateKey, this.issuer, this.audienceUrl, this.tokenTimeout, this.tokenTimeoutUnit, this.schedulerService, this.projectId, this.baseUri, this.tlsConfig, this.configName, this.httpService, this.expressionLanguage, this.defaultHeaders, this.defaultQueryParams, this.connectionTimeout, this.maxConnections, this.connectionIdleTimeout, this.proxyConfig, this.responseBufferSize, this.appName, this.authentication, this.httpClient);
        }
    }
}

