/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection.provider;

import com.mulesoft.connectors.google.bigquery.api.param.proxy.HttpProxyConfig;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.params.OptionalTlsParameterGroup;
import com.mulesoft.connectors.google.bigquery.internal.params.TlsParameterGroup;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;

public abstract class GenericConnectionProvider
implements CachedConnectionProvider<RestConnection>,
Initialisable,
Startable,
Stoppable {
    @DisplayName(value="Project Id")
    @Summary(value="Project id")
    @Parameter
    @Placement(order=2)
    @Optional(defaultValue="")
    protected String projectId;
    @DisplayName(value="Base Uri")
    @Summary(value="Parameter base URI, each instance/tenant gets its own")
    @Parameter
    @Placement(order=3)
    @Optional(defaultValue="https://bigquery.googleapis.com/bigquery/v2")
    protected String baseUri;
    @ParameterGroup(name="Security")
    protected OptionalTlsParameterGroup tlsConfig;
    @RefName
    protected String configName;
    @Inject
    protected HttpService httpService;
    @Inject
    protected ExpressionLanguage expressionLanguage;
    @Parameter
    @Optional
    @NullSafe
    @Placement(tab="Advanced", order=1)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    protected MultiMap<String, String> defaultHeaders;
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="Query Parameters")
    @Placement(tab="Advanced", order=2)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    protected MultiMap<String, String> defaultQueryParams;
    @Parameter
    @Optional(defaultValue="30")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The timeout for establishing connections to the remote service")
    @Placement(tab="Advanced", order=3)
    protected Integer connectionTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced", order=4)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="A time unit which qualifies the Connection Timeout")
    protected TimeUnit connectionTimeoutUnit = TimeUnit.SECONDS;
    @Parameter
    @Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=5)
    @Summary(value="If false, each connection will be closed after the first request is completed.")
    @ExcludeFromConnectivitySchema
    protected boolean usePersistentConnections = true;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=6)
    @Summary(value="The maximum number of outbound connections that will be kept open at the same time")
    @ExcludeFromConnectivitySchema
    protected Integer maxConnections;
    @Parameter
    @Optional(defaultValue="30")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=7)
    @Summary(value="A timeout for how long a connection can remain idle before it is closed")
    protected Integer connectionIdleTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=8)
    @Summary(value="A time unit which qualifies the connection Idle Timeout")
    protected TimeUnit connectionIdleTimeoutUnit = TimeUnit.SECONDS;
    @Parameter
    @Optional
    @Summary(value="Reusable configuration element for outbound connections through a proxy")
    @Placement(tab="Proxy")
    private HttpProxyConfig proxyConfig;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=9)
    @Summary(value="Whether or not received responses should be streamed")
    @ExcludeFromConnectivitySchema
    protected boolean streamResponse = false;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced", order=10)
    @Summary(value="The space in bytes for the buffer where the HTTP response will be stored.")
    @ExcludeFromConnectivitySchema
    protected int responseBufferSize;
    @DisplayName(value="Name app")
    @Summary(value="Parameter app name")
    @Parameter
    @Placement(order=1)
    @Optional(defaultValue="appName1")
    protected String appName;
    private final TlsContextFactoryBuilder defaultTlsContextFactoryBuilder = TlsContextFactory.builder();
    private TlsContextFactory effectiveTlsContextFactory = null;
    private HttpAuthentication authentication;
    private HttpClient httpClient;

    protected GenericConnectionProvider() {
    }

    protected GenericConnectionProvider(String projectId, String baseUri, OptionalTlsParameterGroup tlsConfig, String configName, HttpService httpService, ExpressionLanguage expressionLanguage, MultiMap<String, String> defaultHeaders, MultiMap<String, String> defaultQueryParams, Integer connectionTimeout, Integer maxConnections, Integer connectionIdleTimeout, HttpProxyConfig proxyConfig, int responseBufferSize, String appName, HttpAuthentication authentication, HttpClient httpClient) {
        this();
        this.projectId = projectId;
        this.baseUri = baseUri;
        this.tlsConfig = tlsConfig;
        this.configName = configName;
        this.httpService = httpService;
        this.expressionLanguage = expressionLanguage;
        this.defaultHeaders = defaultHeaders;
        this.defaultQueryParams = defaultQueryParams;
        this.connectionTimeout = connectionTimeout;
        this.maxConnections = maxConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.proxyConfig = proxyConfig;
        this.responseBufferSize = responseBufferSize;
        this.appName = appName;
        this.authentication = authentication;
        this.httpClient = httpClient;
    }

    protected abstract RestConnection createConnection(HttpClient var1, HttpAuthentication var2, MultiMap<String, String> var3, MultiMap<String, String> var4);

    public final void initialise() throws InitialisationException {
        this.initialiseTls();
        this.verifyConnectionsParameters();
        this.authentication = this.buildAuthentication();
        if (this.authentication != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.authentication);
        }
    }

    public void start() {
        this.startHttpClient();
    }

    public void stop() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    private void initialiseTls() throws InitialisationException {
        if (this.tlsConfig != null) {
            HttpConstants.Protocol protocol = this.tlsConfig.getProtocol();
            TlsContextFactory tlsContextFactory = this.tlsConfig.getTlsContext();
            if (protocol.equals((Object)HttpConstants.Protocol.HTTP) && tlsContextFactory != null) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP, when using tls:context you must set attribute protocol=\"HTTPS\""), (Initialisable)this);
            }
            if (protocol.equals((Object)HttpConstants.Protocol.HTTPS) && tlsContextFactory == null) {
                LifecycleUtils.initialiseIfNeeded((Object)this.defaultTlsContextFactoryBuilder);
                tlsContextFactory = this.defaultTlsContextFactoryBuilder.buildDefault();
            }
            if (tlsContextFactory != null) {
                LifecycleUtils.initialiseIfNeeded((Object)tlsContextFactory);
                this.effectiveTlsContextFactory = tlsContextFactory;
            }
        }
    }

    public RestConnection connect() throws ConnectionException {
        try {
            return this.createConnection(this.httpClient, this.authentication, this.defaultQueryParams, this.defaultHeaders);
        }
        catch (Exception e) {
            throw new ConnectionException("Could not create connection", (Throwable)e);
        }
    }

    private void startHttpClient() {
        HttpClientConfiguration.Builder configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.effectiveTlsContextFactory).setProxyConfig((ProxyConfig)this.proxyConfig).setMaxConnections(this.maxConnections.intValue()).setUsePersistentConnections(this.usePersistentConnections).setConnectionIdleTimeout(this.asMillis(this.connectionIdleTimeout, this.connectionTimeoutUnit)).setStreaming(this.streamResponse).setResponseBufferSize(this.responseBufferSize).setName(String.format("connector.google.bigquery.%s", this.configName));
        this.configureTcpSocket(configuration);
        this.httpClient = this.httpService.getClientFactory().create(configuration.build());
        this.httpClient.start();
    }

    protected HttpAuthentication buildAuthentication() {
        return null;
    }

    public final void disconnect(RestConnection restConnection) {
        restConnection.disconnect();
    }

    public ConnectionValidationResult validate(RestConnection restConnection) {
        return restConnection.validate();
    }

    public TlsParameterGroup getTlsConfig() {
        return this.tlsConfig;
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (this.getMaxConnections() != 0 && this.getMaxConnections() >= -1) {
            if (this.isUsePersistentConnections()) {
                this.connectionIdleTimeout = 0;
            }
        } else {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"The maxConnections parameter only allows positive values or -1 for unlimited concurrent connections."), (Initialisable)this);
        }
    }

    private void configureTcpSocket(HttpClientConfiguration.Builder configuration) {
        TcpClientSocketPropertiesBuilder socketProperties = TcpClientSocketProperties.builder();
        if (this.connectionTimeout != null) {
            socketProperties.connectionTimeout(Integer.valueOf(this.asMillis(this.connectionTimeout, this.connectionTimeoutUnit)));
        }
        configuration.setClientSocketProperties(socketProperties.build());
    }

    private int asMillis(Integer value, TimeUnit valueTimeUnit) {
        return value != null && value != -1 ? (int)valueTimeUnit.toMillis(value.intValue()) : -1;
    }

    protected String getProjectId() {
        return this.projectId;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    protected String getConfigName() {
        return this.configName;
    }

    public MultiMap<String, String> getDefaultQueryParams() {
        return this.defaultQueryParams;
    }

    protected boolean isUsePersistentConnections() {
        return this.usePersistentConnections;
    }

    protected Integer getMaxConnections() {
        return this.maxConnections;
    }

    protected ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public HttpAuthentication getAuthentication() {
        return this.authentication;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public static abstract class Builder {
        protected String projectId;
        protected String baseUri;
        protected Integer maxConnections;
        protected Integer connectionTimeout;
        protected TimeUnit connectionTimeoutUnit;
        protected boolean usePersistentConnections;
        protected Integer connectionIdleTimeout;
        protected TimeUnit connectionIdleTimeoutUnit;
        protected boolean streamResponse;
        protected int responseBufferSize;
        protected String appName;
        protected String configName;
        protected HttpService httpService;
        protected ExpressionLanguage expressionLanguage;
        protected OptionalTlsParameterGroup tlsConfig;
        protected MultiMap<String, String> defaultHeaders;
        protected MultiMap<String, String> defaultQueryParams;
        protected HttpProxyConfig proxyConfig;
        protected HttpAuthentication authentication;
        protected HttpClient httpClient;

        public Builder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder withMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder withBaseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder withConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withConnectionTimeoutUnit(TimeUnit connectionTimeoutUnit) {
            this.connectionTimeoutUnit = connectionTimeoutUnit;
            return this;
        }

        public Builder withUsePersistentConnections(boolean usePersistentConnections) {
            this.usePersistentConnections = usePersistentConnections;
            return this;
        }

        public Builder withConnectionIdleTimeout(Integer connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
            return this;
        }

        public Builder withConnectionIdleTimeoutUnit(TimeUnit connectionIdleTimeoutUnit) {
            this.connectionIdleTimeoutUnit = connectionIdleTimeoutUnit;
            return this;
        }

        public Builder withStreamResponse(boolean streamResponse) {
            this.streamResponse = streamResponse;
            return this;
        }

        public Builder withResponseBufferSize(int responseBufferSize) {
            this.responseBufferSize = responseBufferSize;
            return this;
        }

        public Builder withAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder withConfigName(String configName) {
            this.configName = configName;
            return this;
        }

        public Builder withHttpService(HttpService httpService) {
            this.httpService = httpService;
            return this;
        }

        public Builder withExpressionLanguage(ExpressionLanguage expressionLanguage) {
            this.expressionLanguage = expressionLanguage;
            return this;
        }

        public Builder withTlsConfig(OptionalTlsParameterGroup tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        public Builder withDefaultHeaders(MultiMap<String, String> defaultHeaders) {
            this.defaultHeaders = defaultHeaders;
            return this;
        }

        public Builder withDefaultQueryParams(MultiMap<String, String> defaultQueryParams) {
            this.defaultQueryParams = defaultQueryParams;
            return this;
        }

        public Builder withProxyConfig(HttpProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }
    }
}

