/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection;

import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.internal.connection.BigQueryRestConnection;
import com.mulesoft.connectors.google.bigquery.internal.error.RestErrorType;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class OAuthRestConnection
extends BigQueryRestConnection {
    protected OAuthState oAuthState;
    private final String resourceOwnerId;
    private String refreshTokenCondition;
    private LocalDateTime tokenExpirationDate;

    public OAuthRestConnection(String baseUri, String projectId, String configName, HttpClient httpClient, HttpAuthentication authentication, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders, OAuthState oauthState, String resourceOwnerId, ExpressionLanguage expressionLanguage, String refreshTokenCondition) {
        super(httpClient, expressionLanguage, defaultQueryParams, defaultHeaders, baseUri, authentication, projectId);
        this.refreshTokenCondition = refreshTokenCondition;
        Preconditions.checkArgument((resourceOwnerId != null ? 1 : 0) != 0, (String)"resourceOwnerId cannot be null");
        this.resourceOwnerId = resourceOwnerId;
        this.oAuthState = oauthState;
        Preconditions.checkArgument((oauthState != null ? 1 : 0) != 0, (String)"oauthState cannot be null");
        Optional expiresIn = oauthState.getExpiresIn();
        expiresIn.ifPresent(expiresInString -> {
            this.tokenExpirationDate = LocalDateTime.now().plusSeconds(Long.parseLong(expiresInString));
        });
    }

    @Override
    protected HttpRequest buildRequest(RestRequestBuilder requestBuilder) {
        requestBuilder.addHeader("Authorization", "Bearer " + this.oAuthState.getAccessToken());
        return super.buildRequest(requestBuilder);
    }

    private BindingContext buildContext(HttpResponse response, MediaType defaultResponseMediaType) {
        Result result = this.toResult(response, true, defaultResponseMediaType, null);
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", new TypedValue(result.getOutput(), DataType.builder().mediaType(result.getMediaType().orElse(MediaType.ANY)).build())).addBinding("attributes", new TypedValue((Object)result.getAttributes(), DataType.builder().mediaType(result.getAttributesMediaType().orElse(MediaType.ANY)).build()));
        return builder.build();
    }

    public Optional<String> getRefreshTokenCondition() {
        return Optional.ofNullable(this.refreshTokenCondition);
    }

    private ExpressionLanguage requireExpressionLanguage() {
        return this.getExpressionLanguage().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"No expression language support to execute OAuth2 RefreshTokenCondition expression.")));
    }

    private boolean needsRefresh(HttpResponse response, RestErrorType error, MediaType defaultResponseMediaType) {
        this.refreshTokenCondition = this.getRefreshTokenCondition().orElse(null);
        if (this.refreshTokenCondition != null) {
            try {
                return (Boolean)this.requireExpressionLanguage().evaluate(this.refreshTokenCondition, DataType.BOOLEAN, this.buildContext(response, defaultResponseMediaType)).getValue();
            }
            catch (ExpressionExecutionException | ExpressionRuntimeException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to execute defined OAuth2 RefreshTokenCondition expression."), e);
            }
        }
        return error == RestErrorType.UNAUTHORIZED;
    }

    @Override
    protected void handleResponseError(HttpResponse response, MediaType defaultResponseMediaType, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper, RestErrorType error) {
        if (this.needsRefresh(response, error, defaultResponseMediaType)) {
            future.completeExceptionally((Throwable)new AccessTokenExpiredException(this.resourceOwnerId));
        } else {
            super.handleResponseError(response, defaultResponseMediaType, future, streamingHelper, error);
        }
    }
}

