/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection;

import com.mulesoft.connectors.google.bigquery.internal.connection.BigQueryRestConnection;
import com.mulesoft.connectors.google.bigquery.internal.connection.token.ExpirableToken;
import com.mulesoft.connectors.google.bigquery.internal.connection.token.JWTTokenGenerator;
import com.mulesoft.connectors.google.bigquery.internal.connection.token.TokenProvider;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTConnection
extends BigQueryRestConnection {
    private static final Logger logger = LoggerFactory.getLogger(JWTConnection.class);
    private final TokenProvider tokenProvider;

    public JWTConnection(HttpClient httpClient, Scheduler scheduler, ExpressionLanguage expressionLanguage, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders, String baseUri, String projectId, String privateKeyId, String privateKey, String issuer, String audienceUrl, int expirationInterval, TimeUnit expirationIntervalTimeUnit) {
        super(httpClient, expressionLanguage, defaultQueryParams, defaultHeaders, baseUri, null, projectId);
        this.tokenProvider = new TokenProvider(new JWTTokenGenerator(privateKeyId, issuer, issuer, audienceUrl, privateKey), scheduler, expirationInterval, expirationIntervalTimeUnit);
        this.tokenProvider.start();
    }

    @Override
    public void disconnect() {
        logger.debug("Stopping token provider");
        this.tokenProvider.stop();
        logger.trace("disconnection routine");
    }

    @Override
    protected HttpRequest buildRequest(RestRequestBuilder requestBuilder) {
        requestBuilder.addHeader("Authorization", "Bearer " + (String)((ExpirableToken)this.tokenProvider.provide()).getToken());
        return super.buildRequest(requestBuilder);
    }
}

