/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection;

import com.mulesoft.connectors.google.bigquery.api.param.StreamingType;
import com.mulesoft.connectors.google.bigquery.internal.util.ExcludeFromSonarGeneratedCoverage;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class ConfigurationOverrides {
    @Parameter
    @ConfigOverride
    @Placement(tab="Advanced")
    @Summary(value="The timeout for request to the remote service.")
    private Integer responseTimeout;
    @Parameter
    @ConfigOverride
    @Placement(tab="Advanced")
    @Summary(value="A time unit which qualifies the Response Timeout}")
    private TimeUnit responseTimeoutUnit;
    @Parameter
    @ConfigOverride
    @Placement(tab="Advanced")
    @Summary(value="Defines if the request should be sent using streaming. Setting the value to AUTO will automatically define the best strategy based on the request content.")
    private StreamingType streamingType;

    public ConfigurationOverrides() {
    }

    public ConfigurationOverrides(Integer responseTimeout, TimeUnit responseTimeoutUnit, StreamingType streamingType) {
        this.responseTimeout = responseTimeout;
        this.responseTimeoutUnit = responseTimeoutUnit;
        this.streamingType = streamingType;
    }

    public int getResponseTimeoutAsMillis() {
        return (int)this.responseTimeoutUnit.toMillis(this.responseTimeout.intValue());
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public TimeUnit getResponseTimeoutUnit() {
        return this.responseTimeoutUnit;
    }

    @ExcludeFromSonarGeneratedCoverage
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationOverrides that = (ConfigurationOverrides)o;
        return Objects.equals(this.responseTimeout, that.responseTimeout) && this.responseTimeoutUnit == that.responseTimeoutUnit && this.streamingType == that.streamingType;
    }

    @ExcludeFromSonarGeneratedCoverage
    public int hashCode() {
        return Objects.hash(new Object[]{this.responseTimeout, this.responseTimeoutUnit, this.streamingType});
    }
}

