/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.connection;

import com.fasterxml.jackson.databind.JsonNode;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectors.google.bigquery.api.param.HttpResponseAttributes;
import com.mulesoft.connectors.google.bigquery.api.param.StreamingType;
import com.mulesoft.connectors.google.bigquery.internal.config.RestConfiguration;
import com.mulesoft.connectors.google.bigquery.internal.connection.RestConnection;
import com.mulesoft.connectors.google.bigquery.internal.error.RestErrorType;
import com.mulesoft.connectors.google.bigquery.internal.error.exception.RequestException;
import com.mulesoft.connectors.google.bigquery.internal.util.RestRequestBuilder;
import com.mulesoft.connectors.google.bigquery.internal.util.Timer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BigQueryRestConnection
implements RestConnection {
    private static final Logger logger = LoggerFactory.getLogger(BigQueryRestConnection.class);
    private static final String CONNECTION_VALIDATION_ERROR_MESSAGE = "There was an error while validating the connection.";
    private static final String ERROR_CONNECTION_MESSAGE = "Error testing the connection";
    private final String baseUri;
    private final String projectId;
    private final HttpClient httpClient;
    private final HttpAuthentication authentication;
    private final MultiMap<String, String> defaultQueryParams;
    private final MultiMap<String, String> defaultHeaders;
    private final ExpressionLanguage expressionLanguage;

    BigQueryRestConnection(HttpClient httpClient, ExpressionLanguage expressionLanguage, MultiMap<String, String> defaultQueryParams, MultiMap<String, String> defaultHeaders, String baseUri, HttpAuthentication authentication, String projectId) {
        this.baseUri = baseUri;
        this.projectId = projectId;
        this.httpClient = httpClient;
        this.authentication = authentication;
        this.defaultQueryParams = defaultQueryParams;
        this.defaultHeaders = defaultHeaders;
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public void disconnect() {
    }

    private void merge(MultiMap<String, String> defaultValues, Predicate<String> appendPredicate, BiConsumer<String, List<String>> appender) {
        defaultValues.keySet().forEach(k -> {
            if (appendPredicate.test((String)k)) {
                appender.accept((String)k, defaultValues.getAll(k));
            }
        });
    }

    @Override
    public CompletableFuture<Result<Void, HttpResponseAttributes>> bodylessRequest(RestRequestBuilder requestBuilder, int responseTimeoutMillis, MediaType defaultResponseMediaType, StreamingHelper streamingHelper) {
        CompletableFuture<Result<Void, HttpResponseAttributes>> future = new CompletableFuture<Result<Void, HttpResponseAttributes>>();
        this.request(requestBuilder, responseTimeoutMillis, defaultResponseMediaType, streamingHelper).whenComplete((r, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
            } else {
                try {
                    Result.Builder voidResult = Result.builder();
                    r.getAttributes().ifPresent(arg_0 -> ((Result.Builder)voidResult).attributes(arg_0));
                    r.getAttributesMediaType().ifPresent(arg_0 -> ((Result.Builder)voidResult).attributesMediaType(arg_0));
                    future.complete(voidResult.build());
                }
                finally {
                    RestSdkUtils.closeStream((Object)r.getOutput());
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Result<InputStream, HttpResponseAttributes>> request(RestRequestBuilder requestBuilder, int responseTimeoutMillis, MediaType defaultResponseMediaType, StreamingHelper streamingHelper) {
        CompletableFuture<Result<InputStream, HttpResponseAttributes>> future = new CompletableFuture<Result<InputStream, HttpResponseAttributes>>();
        HttpRequest request = this.getHttpRequest(requestBuilder);
        Timer timer = Timer.fromNow();
        try {
            HttpRequestOptions requestOptions = HttpRequestOptions.builder().responseTimeout(responseTimeoutMillis).followsRedirect(true).authentication(this.authentication).build();
            CompletableFuture responseCompletableFuture = this.httpClient.sendAsync(request, requestOptions);
            responseCompletableFuture.whenComplete((response, t) -> {
                try {
                    if (t != null) {
                        this.handleRequestException((Throwable)t, request, future);
                    } else if (response != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Got a response for {} with size {} with last time measure {}", new Object[]{request.getPath(), response.getEntity().getBytesLength(), timer.measure()});
                        }
                        this.handleResponse((HttpResponse)response, defaultResponseMediaType, future, streamingHelper);
                    }
                }
                catch (MuleRuntimeException e) {
                    future.completeExceptionally(e);
                }
                catch (Exception e) {
                    future.completeExceptionally(new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unhandled exception on completing send async."), (Throwable)e));
                }
            });
        }
        catch (Exception e) {
            this.handleRequestException(e, request, future);
        }
        return future;
    }

    @Override
    public ConnectionValidationResult validate() {
        try {
            logger.debug("Validating connection");
            RestRequestBuilder builder = new RestRequestBuilder("https://bigquery.googleapis.com/bigquery/v2/projects", "/", HttpConstants.Method.GET);
            Result<InputStream, HttpResponseAttributes> result = this.request(builder, 30000, MediaType.APPLICATION_JSON, null).get();
            Optional attributes = result.getAttributes();
            if (attributes.isPresent()) {
                if (((HttpResponseAttributes)attributes.get()).getStatusCode() == 200) {
                    logger.trace("Connection validation successful.");
                    return ConnectionValidationResult.success();
                }
                logger.trace(CONNECTION_VALIDATION_ERROR_MESSAGE);
                return ConnectionValidationResult.failure((String)"Error testing connection", (Exception)new ConnectionException(String.format("The test API endpoint returned %d, response body: %s.", ((HttpResponseAttributes)attributes.get()).getStatusCode(), IOUtils.toString((InputStream)((InputStream)result.getOutput())))));
            }
        }
        catch (ExecutionException e) {
            logger.trace(CONNECTION_VALIDATION_ERROR_MESSAGE, (Throwable)e);
            return ConnectionValidationResult.failure((String)ERROR_CONNECTION_MESSAGE, (Exception)e);
        }
        catch (InterruptedException e) {
            logger.trace(CONNECTION_VALIDATION_ERROR_MESSAGE, (Throwable)e);
            Thread.currentThread().interrupt();
            return ConnectionValidationResult.failure((String)ERROR_CONNECTION_MESSAGE, (Exception)e);
        }
        return ConnectionValidationResult.failure((String)ERROR_CONNECTION_MESSAGE, (Exception)new ConnectionException("Unknown error"));
    }

    private HttpRequest getHttpRequest(RestRequestBuilder requestBuilder) {
        MultiMap<String, String> headers = requestBuilder.getHeaders();
        MultiMap<String, String> queryParams = requestBuilder.getQueryParams();
        this.merge(this.defaultHeaders, k -> !headers.containsKey(k), requestBuilder::addHeaders);
        this.merge(this.defaultQueryParams, k -> !queryParams.containsKey(k), requestBuilder::addQueryParams);
        return this.buildRequest(requestBuilder);
    }

    private void handleResponse(HttpResponse response, MediaType defaultResponseMediaType, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper) {
        Optional<RestErrorType> errorByCode = RestErrorType.getErrorByCode(response.getStatusCode());
        if (errorByCode.isPresent()) {
            this.handleResponseError(response, defaultResponseMediaType, future, streamingHelper, errorByCode.get());
        } else {
            future.complete(this.toResult(response, false, defaultResponseMediaType, streamingHelper));
        }
    }

    protected void handleResponseError(HttpResponse response, MediaType defaultResponseMediaType, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future, StreamingHelper streamingHelper, RestErrorType error) {
        future.completeExceptionally((Throwable)((Object)new RequestException(error, this.toResult(response, true, defaultResponseMediaType, streamingHelper))));
    }

    private void handleRequestException(Throwable t, HttpRequest request, CompletableFuture<Result<InputStream, HttpResponseAttributes>> future) {
        logger.debug("Got a throwable with message {}", (Object)t.getMessage());
        this.checkIfRemotelyClosed(t, request);
        RestErrorType error = t instanceof TimeoutException ? RestErrorType.TIMEOUT : RestErrorType.CONNECTIVITY;
        future.completeExceptionally((Throwable)new ModuleException(t.getMessage(), (ErrorTypeDefinition)error, t));
    }

    protected <T> Result<T, HttpResponseAttributes> toResult(HttpResponse response, boolean isError, MediaType defaultResponseMediaType, StreamingHelper streamingHelper) {
        Result.Builder builder = Result.builder();
        HttpEntity entity = response.getEntity();
        InputStream content = entity.getContent();
        if (isError) {
            content = streamingHelper != null ? streamingHelper.resolveCursorProvider((Object)content) : content;
        }
        builder.output((Object)content);
        entity.getBytesLength().ifPresent(arg_0 -> ((Result.Builder)builder).length(arg_0));
        MediaType contentType = defaultResponseMediaType;
        String responseContentType = (String)response.getHeaders().get((Object)"Content-Type");
        if (responseContentType != null) {
            try {
                contentType = MediaType.parse((String)responseContentType);
            }
            catch (Exception e) {
                logger.error(String.format("Response Content-Type '%s' could not be parsed to a valid Media Type. Will ignore", responseContentType), (Throwable)e);
            }
        }
        builder.mediaType(contentType);
        builder.attributes((Object)this.toAttributes(response)).attributesMediaType(MediaType.APPLICATION_JAVA);
        return builder.build();
    }

    protected HttpRequest buildRequest(RestRequestBuilder requestBuilder) {
        return requestBuilder.build();
    }

    protected HttpResponseAttributes toAttributes(HttpResponse response) {
        return new HttpResponseAttributes(response.getStatusCode(), response.getReasonPhrase(), (MultiMap<String, String>)response.getHeaders());
    }

    private void checkIfRemotelyClosed(Throwable exception, HttpRequest request) {
        if ("https".equals(request.getUri().getScheme()) && RestSdkUtils.containsIgnoreCase((String)exception.getMessage(), (String)"Remotely closed")) {
            logger.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public JsonNode createRequestAsJsonNode(String endpoint, String path, HttpConstants.Method method, TypedValue<InputStream> query, RestConfiguration config) {
        try {
            Result<InputStream, HttpResponseAttributes> rowsResponse = this.makeRequest(endpoint, path, method, query, config).get();
            JsonNode responseMap = config.getObjectMapper().readTree((InputStream)rowsResponse.getOutput());
            logger.debug("Response from BigQuery = {}", (Object)responseMap);
            return responseMap;
        }
        catch (IOException | ExecutionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not make request to BigQuery"), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Interrupted while executing the  the request"), (Throwable)e);
        }
    }

    private CompletableFuture<Result<InputStream, HttpResponseAttributes>> makeRequest(String endpoint, String path, HttpConstants.Method method, TypedValue<InputStream> query, RestConfiguration config) {
        RestRequestBuilder builder = new RestRequestBuilder(endpoint, path, method);
        builder.setBody(query, StreamingType.AUTO);
        return this.request(builder, config.getTimeoutConvertedToMillis(), MediaType.APPLICATION_JSON, null);
    }

    protected Optional<ExpressionLanguage> getExpressionLanguage() {
        return Optional.ofNullable(this.expressionLanguage);
    }
}

