/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.google.bigquery.internal.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.google.bigquery.api.param.StreamingType;
import com.mulesoft.connectors.google.bigquery.internal.connection.provider.JWTConnectionProvider;
import com.mulesoft.connectors.google.bigquery.internal.connection.provider.OauthConnectionProvider;
import com.mulesoft.connectors.google.bigquery.internal.operation.GetQueryResultsPagedOperation;
import com.mulesoft.connectors.google.bigquery.internal.operation.JobOperation;
import com.mulesoft.connectors.google.bigquery.internal.operation.ListJobsPagedOperation;
import com.mulesoft.connectors.google.bigquery.internal.operation.QueryPagedOperation;
import com.mulesoft.connectors.google.bigquery.internal.sources.OnTableRowSource;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Operations(value={JobOperation.class, ListJobsPagedOperation.class, GetQueryResultsPagedOperation.class, QueryPagedOperation.class})
@Sources(value={OnTableRowSource.class})
@ConnectionProviders(value={OauthConnectionProvider.class, JWTConnectionProvider.class})
@Configuration(name="config")
@DisplayName(value="Configuration")
public class RestConfiguration
implements Initialisable {
    @DefaultEncoding
    private String defaultEncoding;
    private Charset charset;
    @Parameter
    @Optional(defaultValue="30")
    @Placement(tab="Advanced")
    @Summary(value="The timeout for request to the remote service.")
    private Integer responseTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced")
    @Summary(value="A time unit which qualifies the Response Timeout}")
    private TimeUnit responseTimeoutUnit;
    @Parameter
    @Placement(tab="Advanced")
    @Optional(defaultValue="AUTO")
    @Summary(value="Defines if the request should be sent using streaming. Setting the value to AUTO will automatically define the best strategy based on the request content.")
    private StreamingType streamingType;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public RestConfiguration() {
    }

    public RestConfiguration(String defaultEncoding, Charset charset, Integer responseTimeout, TimeUnit responseTimeoutUnit, StreamingType streamingType) {
        this();
        this.defaultEncoding = defaultEncoding;
        this.charset = charset;
        this.responseTimeout = responseTimeout;
        this.responseTimeoutUnit = responseTimeoutUnit;
        this.streamingType = streamingType;
    }

    public void initialise() {
        this.charset = Charset.forName(this.defaultEncoding);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public TimeUnit getResponseTimeoutUnit() {
        return this.responseTimeoutUnit;
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }

    public int getTimeoutConvertedToMillis() {
        return Math.toIntExact(this.getResponseTimeoutUnit().toMillis(this.getResponseTimeout().intValue()));
    }

    public static class Builder {
        private String defaultEncoding;
        private Charset charset;
        private Integer responseTimeout;
        private TimeUnit responseTimeoutUnit;
        private StreamingType streamingType;

        public Builder withDefaultEncoding(String defaultEncoding) {
            this.defaultEncoding = defaultEncoding;
            return this;
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withResponseTimeout(Integer responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Builder withResponseTimeoutUnit(TimeUnit responseTimeoutUnit) {
            this.responseTimeoutUnit = responseTimeoutUnit;
            return this;
        }

        public Builder withStreamingType(StreamingType streamingType) {
            this.streamingType = streamingType;
            return this;
        }

        public RestConfiguration build() {
            return new RestConfiguration(this.defaultEncoding, this.charset, this.responseTimeout, this.responseTimeoutUnit, this.streamingType);
        }
    }
}

