/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.DuplicatedKeyCheck;
import com.mulesoft.b2b.sync.config.ObjectStoreFactoryFromManager;
import com.mulesoft.b2b.sync.config.SchedulerFactoryFromService;
import com.mulesoft.b2b.sync.config.SyncConfigurationProvided;
import com.mulesoft.b2b.sync.provider.LockWithObjectStoreForCloudHub;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSingleton {
    private static final Logger logger = LoggerFactory.getLogger(SyncSingleton.class);
    private static SyncSingleton instance;
    private final ObjectStoreWithLockManager keyManager;
    private final DuplicatedKeyCheck duplicatedKeyCheck;

    private SyncSingleton(SyncConfigurationProvided syncConfig) {
        this.keyManager = new LockWithObjectStoreForCloudHub(syncConfig).getKeyManagement();
        this.duplicatedKeyCheck = new DuplicatedKeyCheck(this.keyManager);
    }

    public DuplicatedKeyCheck getDuplicatedKeyCheck() {
        return this.duplicatedKeyCheck;
    }

    public ObjectStoreWithLockManager getKeyManager() {
        return this.keyManager;
    }

    public static synchronized SyncSingleton getInstance(SchedulerService service, SchedulerConfig config, LockFactory lockFactory, ObjectStoreManager objectStoreManager, String idObjectStore, Integer daysToStore) {
        return SyncSingleton.getInstance(SyncSingleton.createSyncConfiguration(service, config, lockFactory, objectStoreManager, idObjectStore, daysToStore));
    }

    public static synchronized SyncSingleton getInstanceWitckLockManager(SchedulerService service, SchedulerConfig config, LockFactory lockFactory, ObjectStoreManager objectStoreManager, String idObjectStore, Integer daysToStore) {
        SyncConfigurationProvided configurationProvided = SyncSingleton.createSyncConfiguration(service, config, lockFactory, objectStoreManager, idObjectStore, daysToStore);
        configurationProvided.useLockForSync();
        return SyncSingleton.getInstance(configurationProvided);
    }

    public static synchronized SyncSingleton getInstanceWitckLockWithCH(SchedulerService service, SchedulerConfig config, LockFactory lockFactory, ObjectStoreManager objectStoreManager, String idObjectStore, Integer daysToStore) {
        SyncConfigurationProvided configurationProvided = SyncSingleton.createSyncConfiguration(service, config, lockFactory, objectStoreManager, idObjectStore, daysToStore);
        configurationProvided.useCloudHubForSync();
        return SyncSingleton.getInstance(configurationProvided);
    }

    private static SyncConfigurationProvided createSyncConfiguration(SchedulerService service, SchedulerConfig config, LockFactory lockFactory, ObjectStoreManager objectStoreManager, String idObjectStore, Integer daysToStore) {
        return new SyncConfigurationProvided(idObjectStore).withObjectStoreFactory(new ObjectStoreFactoryFromManager(objectStoreManager, idObjectStore, daysToStore)).withLockFactory(lockFactory).withSchedulerFactory(new SchedulerFactoryFromService(idObjectStore, service, config));
    }

    public static synchronized SyncSingleton getInstance(String idObjectStore, ObjectStore objectStore) {
        return SyncSingleton.getInstance(new SyncConfigurationProvided(idObjectStore).withObjectStore(objectStore));
    }

    public static synchronized SyncSingleton getInstance(SyncConfigurationProvided syncConfig) {
        if (instance == null) {
            instance = new SyncSingleton(syncConfig);
        }
        return instance;
    }
}

