/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import com.mulesoft.b2b.sync.config.SyncConfigurationProvided;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreSimpleManagement
extends ObjectStoreSyncKeyManagement {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreSimpleManagement.class);
    private final Map<String, Lock> keyLocks = new HashMap<String, Lock>();
    private static final long LOCK_WAIT_SECONDS = 15L;

    public ObjectStoreSimpleManagement(SyncConfigurationProvided config) {
        super(config);
    }

    @Override
    public void getLockFor(String key) {
        Lock lockToUse;
        if (this.keyLocks.containsKey(key)) {
            lockToUse = this.keyLocks.get(key);
        } else {
            lockToUse = this.getLockFactory().createLock(key);
            this.keyLocks.put(key, lockToUse);
        }
        try {
            if (!lockToUse.tryLock(15L, TimeUnit.SECONDS)) {
                logger.error("Could not acquire lock to increment number " + key);
                throw new RuntimeException("Could not acquire lock to increment number " + key);
            }
        }
        catch (InterruptedException ie) {
            String excMessage = "Failed acquiring lock to increment number " + key;
            logger.error(excMessage, (Throwable)ie);
            throw new RuntimeException(excMessage, ie);
        }
    }

    @Override
    protected void releaseLockFor(String key) {
        Lock lockToUse = this.keyLocks.get(key);
        if (lockToUse == null) {
            throw new RuntimeException("Lock never obtained");
        }
        lockToUse.unlock();
    }

    @Override
    public String getInfo() {
        return "LockFactory sync for " + super.getInfo();
    }
}

