/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.config;

import com.mulesoft.b2b.sync.config.ObjectStoreFactory;
import com.mulesoft.b2b.sync.config.SchedulerFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.store.ObjectStore;

public class SyncConfigurationProvided {
    private String idToUse;
    private ObjectStore objectStoreToProvide;
    private ObjectStoreFactory objectStoreFactory;
    private LockFactory lockFactory;
    private Scheduler schedulerToProvided;
    private SchedulerFactory schedulerFactory;

    public SyncConfigurationProvided(String idToUse) {
        this.idToUse = idToUse;
        this.lockFactory = null;
    }

    public SyncConfigurationProvided withLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
        return this;
    }

    public SyncConfigurationProvided withObjectStore(ObjectStore objectStore) {
        this.objectStoreToProvide = objectStore;
        return this;
    }

    public SyncConfigurationProvided withObjectStoreFactory(ObjectStoreFactory objectStoreFactory) {
        this.objectStoreFactory = objectStoreFactory;
        return this;
    }

    public SyncConfigurationProvided withScheduler(Scheduler scheduler) {
        this.schedulerToProvided = scheduler;
        return this;
    }

    public SyncConfigurationProvided withSchedulerFactory(SchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
        return this;
    }

    public synchronized ObjectStore getObjectStore() {
        if (this.objectStoreToProvide == null) {
            if (this.objectStoreFactory == null) {
                throw new RuntimeException("No object store provided neither factory to create it");
            }
            this.objectStoreToProvide = this.objectStoreFactory.createObjectStore();
        }
        return this.objectStoreToProvide;
    }

    public synchronized Scheduler getScheduler() {
        if (this.schedulerToProvided == null) {
            if (this.schedulerFactory == null) {
                throw new RuntimeException("No scheduler provided neither factory to create it");
            }
            this.schedulerToProvided = this.schedulerFactory.createScheduler();
        }
        return this.schedulerToProvided;
    }

    public LockFactory getLockFactory() {
        if (this.lockFactory == null) {
            throw new RuntimeException("No lock factory provided");
        }
        return this.lockFactory;
    }

    public String getIdToUse() {
        return this.idToUse;
    }
}

