/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.amazon.client;

import com.mulesoft.connectors.awslambda.internal.amazon.AwsCredentials;
import com.mulesoft.connectors.awslambda.internal.amazon.AwsHttpRequest;
import com.mulesoft.connectors.awslambda.internal.amazon.AwsSignature;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class AwsHttpClient
implements HttpClient {
    private final HttpClient httpClient;
    private final String service;
    private final AwsCredentials credentials;

    public AwsHttpClient(HttpClient client, String service, AwsCredentials credentials) {
        this.service = service.toLowerCase();
        this.credentials = credentials;
        this.httpClient = client;
    }

    public void start() {
        this.httpClient.start();
    }

    public void stop() {
        this.httpClient.stop();
    }

    public HttpResponse send(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
        AwsHttpRequest awsHttpRequest = new AwsHttpRequest(request);
        AwsSignature signature = new AwsSignature(awsHttpRequest, this.service, this.credentials);
        awsHttpRequest.sign(signature);
        return this.httpClient.send((HttpRequest)awsHttpRequest, options);
    }

    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, HttpRequestOptions options) {
        AwsHttpRequest awsHttpRequest = new AwsHttpRequest(request);
        AwsSignature signature = new AwsSignature(awsHttpRequest, this.service, this.credentials);
        awsHttpRequest.sign(signature);
        return this.httpClient.sendAsync((HttpRequest)awsHttpRequest, options);
    }
}

