/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.awslambda.internal.amazon;

import com.mulesoft.connectors.awslambda.internal.amazon.AwsSignature;
import com.mulesoft.connectors.awslambda.internal.error.exception.AwsClientException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.BaseHttpMessage;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsHttpRequest
extends BaseHttpMessage
implements HttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(AwsHttpRequest.class);
    static final String AMZ_DATE = "X-Amz-Date";
    static final String AMZ_CONTENT_SHA256 = "X-Amz-Content-SHA256";
    static final String AMZ_SECURITY_TOKEN = "X-Amz-Security-Token";
    private final URI uri;
    private final String path;
    private final HttpProtocol protocol;
    private final String method;
    private final MultiMap<String, String> queryParams;
    private final HttpEntity entity;
    private final String payloadHash;

    public AwsHttpRequest(HttpRequest httpRequest) {
        this.headers = new MultiMap(httpRequest.getHeaders());
        this.uri = httpRequest.getUri();
        this.path = this.uri.getPath();
        this.protocol = httpRequest.getProtocol();
        this.method = httpRequest.getMethod();
        this.queryParams = httpRequest.getQueryParams();
        this.entity = httpRequest.getEntity();
        this.payloadHash = StringUtils.toHexString((byte[])this.hash(this.safeDataCopy()));
    }

    InputStream safeDataCopy() {
        try {
            HttpEntity httpEntity = this.getEntity();
            if (httpEntity == null || httpEntity.getContent() == null || httpEntity instanceof EmptyHttpEntity) {
                logger.debug("Preparing Empty AWS Request.");
                return new ByteArrayInputStream(new byte[0]);
            }
            if (httpEntity instanceof ByteArrayHttpEntity) {
                logger.debug("Preparing Simple AWS Request.");
                return new ByteArrayInputStream(httpEntity.getBytes());
            }
            InputStream inputStream = httpEntity.getContent();
            if (inputStream instanceof CursorStream) {
                logger.debug("Preparing Streamed AWS Request.");
                CursorStream cursor = (CursorStream)inputStream;
                long pos = cursor.getPosition();
                byte[] copy = httpEntity.getBytes();
                cursor.seek(pos);
                return new ByteArrayInputStream(copy);
            }
            if (!inputStream.markSupported()) {
                throw new AwsClientException("The supplied streaming type is not supported");
            }
            logger.debug("Preparing AWS Request.");
            inputStream.mark(-1);
            byte[] copy = IOUtils.toByteArray((InputStream)inputStream);
            inputStream.reset();
            return new ByteArrayInputStream(copy);
        }
        catch (Exception e) {
            throw new AwsClientException("Failed to retrieve request content", e);
        }
    }

    public String getHash() {
        return this.payloadHash;
    }

    public void sign(AwsSignature signature) {
        this.sign(signature, null);
    }

    public void sign(AwsSignature signature, String sessionToken) {
        this.headers.put((Object)AMZ_DATE, (Object)signature.getTimeStamp());
        if (this.headers.containsKey((Object)AMZ_CONTENT_SHA256) && ((String)this.headers.get((Object)AMZ_CONTENT_SHA256)).equals("required")) {
            this.headers.removeAll((Object)AMZ_CONTENT_SHA256);
            this.headers.put((Object)AMZ_CONTENT_SHA256, (Object)this.payloadHash);
        }
        if (sessionToken != null) {
            this.headers.put((Object)AMZ_SECURITY_TOKEN, (Object)sessionToken);
        }
        this.headers.put((Object)"Host", (Object)this.uri.getHost());
        this.headers.put((Object)"Authorization", (Object)signature.getSignature());
    }

    private byte[] hash(InputStream input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            DigestInputStream digestInputStream = new DigestInputStream(input, md);
            byte[] buffer = new byte[63];
            int read = 0;
            while (read > -1) {
                read = digestInputStream.read(buffer);
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new AwsClientException("Failed to create payload hash for AWS request", e);
        }
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    public HttpProtocol getProtocol() {
        return this.protocol;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return "AwsHttpRequest {" + System.lineSeparator() + "  uri: " + this.uri.toString() + "," + System.lineSeparator() + "  path: " + this.path + "," + System.lineSeparator() + "  method: " + this.method + "," + System.lineSeparator() + "  headers: " + this.headers.toString() + "," + System.lineSeparator() + "  queryParams: " + this.queryParams.toString() + System.lineSeparator() + "}";
    }
}

