/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.internal.util.RestSdkUtils;
import java.util.Iterator;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class SplitPayloadUtils {
    public static Iterator<TypedValue<?>> split(ExpressionLanguage expressionLanguage, TypedValue<?> payload) {
        return SplitPayloadUtils.split(expressionLanguage, payload, null);
    }

    public static Iterator<TypedValue<?>> split(ExpressionLanguage expressionLanguage, TypedValue<?> payload, String previousExpression) {
        Iterator splitResult;
        if (payload.getDataType().getMediaType().matches(MediaType.APPLICATION_XML)) {
            SplitPayloadUtils.validatePayload(expressionLanguage, payload, "#[payload is Object]", previousExpression);
            splitResult = expressionLanguage.split("#[payload[0] default []]", SplitPayloadUtils.buildContext(payload));
        } else {
            SplitPayloadUtils.validatePayload(expressionLanguage, payload, "#[payload is Array]", previousExpression);
            splitResult = expressionLanguage.split("#[payload]", SplitPayloadUtils.buildContext(payload));
        }
        return splitResult;
    }

    private static void validatePayload(ExpressionLanguage expressionLanguage, TypedValue<?> payload, String expression, String previousExpression) {
        TypedValue result = expressionLanguage.evaluate(expression, DataType.BOOLEAN, SplitPayloadUtils.buildContext(payload));
        if (result.getValue().equals(false)) {
            String stringMessage = RestSdkUtils.isBlank(expression) ? String.format("Failed to split payload that is not an array. Expression: '%s'. Result Payload: '%s'.", previousExpression, payload.getValue()) : String.format("Failed to split payload that is not an array. Result Payload: '%s'.", payload.getValue());
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)stringMessage));
        }
    }

    private static BindingContext buildContext(TypedValue<?> payload) {
        return BindingContext.builder().addBinding("payload", payload).build();
    }
}

