/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.configuration;

import com.mulesoft.connectivity.amazonlambdaconnector.rest.commons.api.configuration.StreamingType;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class RestConfiguration
implements Initialisable {
    @DefaultEncoding
    private String defaultEncoding;
    private Charset charset;
    @Parameter
    @Optional(defaultValue="1")
    @Placement(tab="Advanced")
    @Summary(value="The timeout for request to the remote service.")
    private Integer responseTimeout;
    @Parameter
    @Optional(defaultValue="MINUTES")
    @Placement(tab="Advanced")
    @Summary(value="A time unit which qualifies the Response Timeout}")
    private TimeUnit responseTimeoutUnit = TimeUnit.MINUTES;
    @Parameter
    @Placement(tab="Advanced")
    @Optional(defaultValue="AUTO")
    @Summary(value="Defines if the request should be sent using streaming. Setting the value to AUTO will automatically define the best strategy based on the request content.")
    private StreamingType streamingType;

    public void initialise() {
        this.charset = Charset.forName(this.defaultEncoding);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public TimeUnit getResponseTimeoutUnit() {
        return this.responseTimeoutUnit;
    }

    public StreamingType getStreamingType() {
        return this.streamingType;
    }
}

