/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.source;

import com.mulesoft.connectors.ws.internal.WebSocketsConnector;
import com.mulesoft.connectors.ws.internal.connection.FluxCapacitor;
import com.mulesoft.connectors.ws.internal.server.WebSocketServer;
import com.mulesoft.connectors.ws.internal.util.WebSocketUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.source.Source;

public abstract class PathSource<T, A>
extends Source<T, A> {
    @Parameter
    @Placement(order=1)
    protected String path;
    @Config
    protected WebSocketsConnector config;
    @Connection
    protected ConnectionProvider<FluxCapacitor> connectionProvider;
    protected FluxCapacitor fluxCapacitor;
    protected WebSocketServer webSocketServer;

    protected void engageFluxCapacitor() throws ConnectionException {
        this.fluxCapacitor = (FluxCapacitor)this.connectionProvider.connect();
        this.webSocketServer = this.fluxCapacitor.unsafeGetWebSocketServer(this.config);
    }

    protected void disengageFluxCapacitor() {
        if (this.fluxCapacitor != null) {
            this.connectionProvider.disconnect((Object)this.fluxCapacitor);
            this.fluxCapacitor = null;
        }
    }

    protected String resolvePath() {
        String basePath = this.webSocketServer.getServerSettings().getListenerBasePath();
        return WebSocketUtils.getFullListenerPath(WebSocketUtils.sanitizePathWithStartSlash(this.path), basePath).getResolvedPath();
    }
}

