/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.source;

import com.mulesoft.connectors.ws.api.WebSocketAttributes;
import com.mulesoft.connectors.ws.api.client.WebSocketClientSettings;
import com.mulesoft.connectors.ws.internal.WebSocketsConnector;
import com.mulesoft.connectors.ws.internal.connection.FluxCapacitor;
import com.mulesoft.connectors.ws.internal.util.WebSocketUtils;
import java.io.InputStream;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

@Alias(value="outbound-listener")
@DisplayName(value="On New Outbound Message")
@Summary(value="Triggers when a message is received from an inbound WebSocket")
@MediaType(value="*/*", strict=false)
public class OutboundSocketMessageListener
extends Source<InputStream, WebSocketAttributes> {
    @Parameter
    @Placement(order=1)
    private String path;
    @Config
    private WebSocketsConnector config;
    @Connection
    private ConnectionProvider<FluxCapacitor> connectionProvider;
    private FluxCapacitor fluxCapacitor;
    private String resolvedPath;

    public void onStart(SourceCallback<InputStream, WebSocketAttributes> sourceCallback) throws MuleException {
        this.fluxCapacitor = (FluxCapacitor)this.connectionProvider.connect();
        this.resolvePath();
        this.fluxCapacitor.getOutboundSocketListener().addMessageHandler(this.resolvedPath, (socket, attributes, content) -> this.onMessage(attributes, (TypedValue<InputStream>)content, sourceCallback));
    }

    private void resolvePath() {
        WebSocketClientSettings settings = this.fluxCapacitor.unsafeGetWebSocketClient(this.config).getSettings();
        this.resolvedPath = WebSocketUtils.resolveFullPath(settings.getBasePath(), this.path);
    }

    public void onStop() {
        if (this.fluxCapacitor != null && this.resolvedPath != null) {
            this.fluxCapacitor.getOutboundSocketListener().removeMessageHandler(this.resolvedPath);
            this.resolvedPath = null;
        }
    }

    private void onMessage(WebSocketAttributes attributes, TypedValue<InputStream> content, SourceCallback<InputStream, WebSocketAttributes> sourceCallback) {
        Result result = Result.builder().output(content.getValue()).mediaType(content.getDataType().getMediaType()).attributes((Object)attributes).build();
        sourceCallback.handle(result);
    }
}

