/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.source;

import com.mulesoft.connectors.ws.api.ClosedConnectionEvent;
import com.mulesoft.connectors.ws.api.WebSocketAttributes;
import com.mulesoft.connectors.ws.internal.connection.FluxCapacitor;
import com.mulesoft.connectors.ws.internal.server.OnCloseCallback;
import com.mulesoft.connectors.ws.internal.source.PathSource;
import com.mulesoft.connectors.ws.internal.util.WebSocketUtils;
import java.util.HashSet;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

@Alias(value="on-socket-closed")
@DisplayName(value="On Socket Closed")
@Summary(value="Triggers when a WebSocket is closed.")
public class CloseConnectionListener
extends PathSource<ClosedConnectionEvent, WebSocketAttributes> {
    private HashSet<String> resolvedPaths = new HashSet(2);
    private OnCloseCallback callback;

    public void onStart(SourceCallback<ClosedConnectionEvent, WebSocketAttributes> sourceCallback) throws MuleException {
        this.fluxCapacitor = (FluxCapacitor)this.connectionProvider.connect();
        if (this.fluxCapacitor.getWebSocketServer().isPresent()) {
            this.webSocketServer = this.fluxCapacitor.getWebSocketServer().get();
            this.resolvedPaths.add(this.resolvePath());
        } else if (!this.fluxCapacitor.getWebSocketClient().isPresent()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"No connection settings could be resolved for CloseConnectionListener."));
        }
        if (this.fluxCapacitor.getWebSocketClient().isPresent()) {
            this.resolvedPaths.add(WebSocketUtils.resolveFullPath(this.fluxCapacitor.getWebSocketClient().get().getSettings().getBasePath(), this.path));
        }
        this.callback = (state, closeCode, reason) -> {
            Result result = Result.builder().output((Object)new ClosedConnectionEvent(closeCode, reason)).attributes((Object)state.getAttributes()).build();
            sourceCallback.handle(result);
        };
        for (String resolvedPath : this.resolvedPaths) {
            this.fluxCapacitor.registerOnCloseCallback(resolvedPath, this.callback);
        }
    }

    public void onStop() {
        if (this.callback != null) {
            for (String resolvedPath : this.resolvedPaths) {
                this.fluxCapacitor.unregisterOnCloseCallback(resolvedPath, this.callback);
            }
        }
        this.disengageFluxCapacitor();
    }
}

