/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.error;

import java.util.Optional;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.http.api.HttpConstants;

public enum WsError implements ErrorTypeDefinition<WsError>
{
    CONNECTIVITY((ErrorTypeDefinition<? extends Enum<?>>)MuleErrors.CONNECTIVITY),
    CLIENT_SECURITY((ErrorTypeDefinition<? extends Enum<?>>)MuleErrors.CLIENT_SECURITY),
    SERVER_SECURITY((ErrorTypeDefinition<? extends Enum<?>>)MuleErrors.SERVER_SECURITY),
    BASIC_AUTHENTICATION(SERVER_SECURITY),
    UNAUTHORIZED(CLIENT_SECURITY),
    FORBIDDEN(CLIENT_SECURITY),
    NOT_FOUND,
    SERVICE_UNAVAILABLE,
    NO_SUCH_SOCKET,
    INVALID_SOCKET_ID,
    NON_UNIQUE_SOCKET_ID,
    REMOTELY_CLOSED,
    INTERNAL_SERVER_ERROR;

    private ErrorTypeDefinition<? extends Enum<?>> parent;

    private WsError(ErrorTypeDefinition<? extends Enum<?>> parent) {
        this.parent = parent;
    }

    private WsError() {
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public static Optional<WsError> getErrorByCode(int statusCode) {
        WsError error = null;
        HttpConstants.HttpStatus status = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
        if (status != null) {
            try {
                error = WsError.valueOf(status.name());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.ofNullable(error);
    }
}

