/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.connection;

import com.mulesoft.connectors.ws.api.exception.NoSuchSocketException;
import com.mulesoft.connectors.ws.internal.connection.WebSocketState;
import com.mulesoft.connectors.ws.internal.error.WsError;
import com.mulesoft.connectors.ws.internal.util.UsesReadWriteLock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.runtime.http.api.ws.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketRegistry
extends UsesReadWriteLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketRegistry.class);
    private final Map<String, WebSocketState> sockets = new HashMap<String, WebSocketState>();
    private final RequestMatcherRegistry<List<WebSocketState>> socketPathRegistry;

    public SocketRegistry(HttpService httpService) {
        this.socketPathRegistry = httpService.getRequestMatcherRegistryBuilder().build();
    }

    public void registerSocket(WebSocketState state) {
        WebSocket socket = state.getWebSocket();
        this.withWriteLock(() -> {
            if (this.sockets.putIfAbsent(socket.getId(), state) != null) {
                throw new ModuleException("A WebSocket with id '" + socket.getId() + "' already exists", (ErrorTypeDefinition)WsError.NON_UNIQUE_SOCKET_ID);
            }
            String path = socket.getUri().getPath();
            LinkedList<WebSocketState> pathEntry = (LinkedList<WebSocketState>)this.socketPathRegistry.find("GET", path);
            if (pathEntry == null) {
                pathEntry = new LinkedList<WebSocketState>();
                PathAndMethodRequestMatcher matcher = PathAndMethodRequestMatcher.builder().path(path).methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).build();
                this.socketPathRegistry.add(matcher, pathEntry);
            }
            pathEntry.add(state);
        });
    }

    public WebSocketState unregisterSocket(WebSocket socket) {
        return (WebSocketState)this.withWriteLock(() -> {
            WebSocketState state = this.sockets.remove(socket.getId());
            if (state != null) {
                this.removeFromPathRegistry(socket, state);
            }
            return state;
        });
    }

    public WebSocket getSocket(String id) {
        return (WebSocket)this.withReadLock(() -> {
            WebSocketState state = this.sockets.get(id);
            if (state == null) {
                throw new NoSuchSocketException(id);
            }
            return state.getWebSocket();
        });
    }

    public WebSocketState getSocketState(String id) {
        return (WebSocketState)this.withReadLock(() -> this.sockets.get(id));
    }

    public Collection<WebSocket> lookup(String path, Predicate<WebSocket> filter) {
        return (Collection)this.withReadLock(() -> this.filter(filter, (Collection)this.socketPathRegistry.find("GET", path)));
    }

    public Collection<WebSocket> lookup(Predicate<WebSocket> filter) {
        return (Collection)this.withReadLock(() -> this.filter(filter, this.sockets.values()));
    }

    private List<WebSocket> filter(Predicate<WebSocket> filter, Collection<WebSocketState> sockets) {
        if (sockets == null) {
            return Collections.emptyList();
        }
        return sockets.stream().map(WebSocketState::getWebSocket).filter(filter).collect(Collectors.toList());
    }

    public void forEach(Consumer<WebSocket> consumer) {
        this.withReadLock(() -> this.sockets.values().forEach((? super T state) -> {
            block2: {
                WebSocket socket = state.getWebSocket();
                try {
                    consumer.accept(socket);
                }
                catch (Throwable t) {
                    if (!LOGGER.isWarnEnabled()) break block2;
                    LOGGER.warn(String.format("Exception found while processing socket '%s'. %s", socket.getId(), t.getMessage()), t);
                }
            }
        }));
    }

    private void removeFromPathRegistry(WebSocket socket, WebSocketState state) {
        this.withWriteLock(() -> {
            List socketPaths = (List)this.socketPathRegistry.find("GET", socket.getUri().getPath());
            if (socketPaths != null) {
                socketPaths.remove(state);
            }
        });
    }
}

