/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.connection;

import com.mulesoft.connectors.ws.internal.server.OnCloseCallback;
import com.mulesoft.connectors.ws.internal.util.UsesReadWriteLock;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OnCloseListenerRegistry
extends UsesReadWriteLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnCloseListenerRegistry.class);
    private final RequestMatcherRegistry<List<OnCloseCallback>> onCloseCallbacks;

    OnCloseListenerRegistry(HttpService httpService) {
        this.onCloseCallbacks = httpService.getRequestMatcherRegistryBuilder().build();
    }

    void registerOnCloseCallback(String path, OnCloseCallback callback) {
        this.withWriteLock(() -> {
            LinkedList<OnCloseCallback> callbacks = (LinkedList<OnCloseCallback>)this.onCloseCallbacks.find("GET", path);
            if (callbacks == null) {
                callbacks = new LinkedList<OnCloseCallback>();
                PathAndMethodRequestMatcher matcher = PathAndMethodRequestMatcher.builder().path(path).methodRequestMatcher(MethodRequestMatcher.builder().add(HttpConstants.Method.GET).build()).build();
                this.onCloseCallbacks.add(matcher, callbacks);
            }
            callbacks.add(callback);
        });
    }

    void unregisterOnCloseCallback(String path, OnCloseCallback callback) {
        this.withWriteLock(() -> {
            List callbacks = (List)this.onCloseCallbacks.find("GET", path);
            if (callbacks != null) {
                callbacks.remove(callback);
            }
        });
    }

    void forEach(String path, Consumer<OnCloseCallback> consumer) {
        this.withReadLock(() -> {
            List callbacks = (List)this.onCloseCallbacks.find("GET", path);
            if (callbacks == null) {
                return;
            }
            callbacks.forEach(c -> {
                block2: {
                    try {
                        consumer.accept((OnCloseCallback)c);
                    }
                    catch (Throwable t) {
                        if (!LOGGER.isWarnEnabled()) break block2;
                        LOGGER.warn(String.format("Exception found while trying to invoke on close callback for path '%s'. %s", path, t.getMessage()), t);
                    }
                }
            });
        });
    }
}

