/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.client;

import com.mulesoft.connectors.ws.api.WebSocketAttributes;
import com.mulesoft.connectors.ws.api.client.WebSocketClientSettings;
import com.mulesoft.connectors.ws.internal.client.OutboundSocketMessageHandler;
import com.mulesoft.connectors.ws.internal.connection.FluxCapacitor;
import com.mulesoft.connectors.ws.internal.connection.OutboundSocketListener;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundSocketCallback
implements WebSocketCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundSocketCallback.class);
    private final FluxCapacitor fluxCapacitor;
    private final OutboundSocketListener outboundSocketListener;
    private final HttpRequest request;
    private final List<String> defaultGroups;
    private final WebSocketClientSettings settings;
    private WebSocketAttributes attributes;

    public OutboundSocketCallback(FluxCapacitor fluxCapacitor, OutboundSocketListener outboundSocketListener, HttpRequest request, List<String> defaultGroups, WebSocketClientSettings settings) {
        this.fluxCapacitor = fluxCapacitor;
        this.outboundSocketListener = outboundSocketListener;
        this.request = request;
        this.defaultGroups = defaultGroups;
        this.settings = settings;
    }

    public void onConnect(WebSocket webSocket) {
        this.attributes = new WebSocketAttributes(webSocket.getId(), WebSocket.WebSocketType.OUTBOUND, this.defaultGroups, this.request.getUri().getPath(), this.request.getUri().toString(), this.settings.getProtocol(), (MultiMap<String, String>)this.request.getQueryParams(), (MultiMap<String, String>)this.request.getHeaders(), Collections.emptyMap(), this.request.getMethod(), this.request.getUri().getQuery());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Outbound socket established. Id: {}, URI: {}", (Object)webSocket.getId(), (Object)webSocket.getUri().toString());
        }
    }

    public void onClose(WebSocket webSocket, WebSocketCloseCode code, String reason) {
        this.fluxCapacitor.notifyClosed(webSocket, code, reason, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Outbound socket closed. Id: {}, URI: {}", (Object)webSocket.getId(), (Object)webSocket.getUri().toString());
        }
    }

    public void onMessage(WebSocket webSocket, TypedValue<InputStream> content) {
        Optional<OutboundSocketMessageHandler> handler = this.outboundSocketListener.getMessageHandler(webSocket.getUri().getPath());
        if (handler.isPresent()) {
            handler.get().handle(webSocket, this.attributes, content);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("A message was received on OUTBOUND socket connected to {}. However, no <websocket:outbound-listener> was defined for it or it has been stopped.", (Object)webSocket.getUri().toString());
        }
    }

    public WebSocketAttributes getSocketAttributes() {
        Preconditions.checkState((this.attributes != null ? 1 : 0) != 0, (String)"Socket has not been established yet");
        return this.attributes;
    }
}

