/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.api.client;

import com.mulesoft.connectors.ws.api.client.QueryParam;
import com.mulesoft.connectors.ws.api.client.RequestHeader;
import com.mulesoft.connectors.ws.api.client.proxy.HttpProxyConfig;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.mule.sdk.api.annotation.semantics.connectivity.Host;
import org.mule.sdk.api.annotation.semantics.connectivity.Port;
import org.mule.sdk.api.annotation.semantics.connectivity.UrlPath;

public class WebSocketClientSettings {
    public static final String DEFAULT_MAX_CONNECTIONS = "-1";
    @Parameter
    @Optional
    @Example(value="www.mulesoft.com")
    @Placement(order=1, tab="Client Settings")
    @Summary(value="Host where the requests will be sent.")
    @Host
    private String host;
    @Parameter
    @Optional
    @Placement(order=2, tab="Client Settings")
    @Summary(value="Port where the requests will be sent")
    @Port
    private Integer port;
    @Parameter
    @Optional(defaultValue="/")
    @Placement(order=3, tab="Client Settings")
    @Summary(value="Base path to use for all outbound sockets that reference this config.")
    @UrlPath
    private String basePath;
    @Parameter
    @Optional(defaultValue="WS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Protocol to use for outbound communication.")
    @Placement(order=4, tab="Client Settings")
    private WebSocketProtocol protocol;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Outbound TLS Configuration")
    @Placement(order=5, tab="Client Settings")
    @Summary(value="Reference to a TLS config element. This will enable WSS for outbound sockets")
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @NullSafe
    @Placement(tab="Client Settings", order=6)
    @Summary(value="Default HTTP headers the message should include.")
    private List<RequestHeader> defaultHeaders;
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="Query Parameters")
    @Placement(tab="Client Settings", order=7)
    @Summary(value="Default Query parameters the request should include.")
    private List<QueryParam> defaultQueryParams;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Client Settings", order=8)
    @Summary(value="A timeout for idle connections to be closed. If not specified, there'll be no timeout")
    private Integer connectionIdleTimeout;
    @Parameter
    @Optional(defaultValue="MINUTES")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Client Settings", order=9)
    @Summary(value="Timeout unit that qualifies the connectionIdleTimeout")
    private TimeUnit connectionIdleTimeoutUnit = TimeUnit.MINUTES;
    @Parameter
    @Optional(defaultValue="true")
    @Placement(tab="Client Settings", order=10)
    @Summary(value="Specifies whether to follow redirects or not.")
    @ExcludeFromConnectivitySchema
    private boolean followRedirects;
    @Parameter
    @Optional(defaultValue="false")
    @Placement(tab="Client Settings", order=11)
    @ExcludeFromConnectivitySchema
    private boolean preserveHeadersCase = false;
    @Parameter
    @Optional(defaultValue="-1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Client Settings", order=12)
    @ExcludeFromConnectivitySchema
    private Integer maxConnections;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Reusable configuration element for outbound connections through a proxy")
    @Placement(tab="Proxy")
    private HttpProxyConfig proxyConfig;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Authentication")
    private HttpRequestAuthentication authentication;

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setProtocol(WebSocketProtocol protocol) {
        this.protocol = protocol;
    }

    public void setDefaultHeaders(List<RequestHeader> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public void setDefaultQueryParams(List<QueryParam> defaultQueryParams) {
        this.defaultQueryParams = defaultQueryParams;
    }

    public Integer getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public void setConnectionIdleTimeout(Integer connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public TimeUnit getConnectionIdleTimeoutUnit() {
        return this.connectionIdleTimeoutUnit;
    }

    public void setConnectionIdleTimeoutUnit(TimeUnit connectionIdleTimeoutUnit) {
        this.connectionIdleTimeoutUnit = connectionIdleTimeoutUnit;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setPreserveHeadersCase(boolean preserveHeadersCase) {
        this.preserveHeadersCase = preserveHeadersCase;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setProxyConfig(HttpProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void setAuthentication(HttpRequestAuthentication authentication) {
        this.authentication = authentication;
    }

    public int getConnectionIdleTimeoutMillis() {
        try {
            return this.connectionIdleTimeout != null ? Math.toIntExact(this.connectionIdleTimeoutUnit.toMillis(this.connectionIdleTimeout.intValue())) : Integer.MAX_VALUE;
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public WebSocketProtocol getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public List<RequestHeader> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public List<QueryParam> getDefaultQueryParams() {
        return this.defaultQueryParams;
    }

    public boolean isPreserveHeadersCase() {
        return this.preserveHeadersCase;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public void setTlsContext(TlsContextFactory tlsContext) {
        this.tlsContext = tlsContext;
    }

    public HttpProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public HttpRequestAuthentication getAuthentication() {
        return this.authentication;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketClientSettings that = (WebSocketClientSettings)o;
        return this.followRedirects == that.followRedirects && this.preserveHeadersCase == that.preserveHeadersCase && Objects.equals(this.basePath, that.basePath) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && this.protocol == that.protocol && Objects.equals(this.tlsContext, that.tlsContext) && Objects.equals(this.defaultHeaders, that.defaultHeaders) && Objects.equals(this.defaultQueryParams, that.defaultQueryParams) && Objects.equals(this.connectionIdleTimeout, that.connectionIdleTimeout) && Objects.equals(this.maxConnections, that.maxConnections) && Objects.equals(this.proxyConfig, that.proxyConfig) && Objects.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return Objects.hash(this.basePath, this.host, this.port, this.protocol, this.tlsContext, this.defaultHeaders, this.defaultQueryParams, this.connectionIdleTimeout, this.followRedirects, this.preserveHeadersCase, this.maxConnections, this.proxyConfig, this.authentication);
    }
}

