/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.utils;

import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.SharepointQueryTranslator;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.manager.MetadataManager;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import java.io.FileNotFoundException;
import java.net.URL;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.QueryTranslator;

public class SharepointUtils {
    public static final String QUERY_START_INDICATOR = "?";

    private SharepointUtils() {
    }

    public static String translateDsqlQuery(SharepointService client, String query) {
        if (DsqlParser.isDsqlQuery((String)query)) {
            MetadataManager metadataManager = new MetadataManager(client);
            DsqlQuery dsqlQuery = DsqlParser.getInstance().parse(query);
            SharepointQueryTranslator translator = new SharepointQueryTranslator(metadataManager);
            translator.translateTypes(dsqlQuery.getType());
            query = dsqlQuery.translate((QueryTranslator)translator);
        }
        return query;
    }

    public static String extractPath(String parsedQuery) {
        int indexOfQuery = parsedQuery.indexOf(QUERY_START_INDICATOR);
        if (indexOfQuery > -1) {
            return parsedQuery.substring(0, indexOfQuery);
        }
        return parsedQuery;
    }

    public static String extractQueryString(String parsedQuery) {
        int indexOfQuery = parsedQuery.indexOf(QUERY_START_INDICATOR);
        if (indexOfQuery > -1) {
            return parsedQuery.substring(indexOfQuery + 1, parsedQuery.length());
        }
        return "";
    }

    public static String resolvePathToAbsolutePath(String path) throws FileNotFoundException {
        URL resource = SharepointUtils.class.getClassLoader().getResource(path);
        if (resource != null) {
            return resource.getPath();
        }
        throw new FileNotFoundException("Unable to locate the file " + path);
    }
}

