/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.utils;

import java.util.Iterator;
import java.util.Objects;

public class ConnectorUtils {
    public static final String EMPTY = "";

    private ConnectorUtils() {
    }

    public static boolean isStringNullOrEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static String substringBefore(String str, String separator) {
        if (!str.isEmpty() && separator != null) {
            if (ConnectorUtils.isEmpty(separator)) {
                return EMPTY;
            }
            int pos = str.indexOf(separator);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !ConnectorUtils.isBlank(str);
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return null;
        }
        return ConnectorUtils.join(iterable.iterator(), separator);
    }

    public static String removeStart(String str, String remove) {
        if (ConnectorUtils.isEmpty(str) || ConnectorUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (ConnectorUtils.isEmpty(str) || ConnectorUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !ConnectorUtils.isEmpty(cs);
    }

    public static String substringAfterLast(String str, String separator) {
        if (ConnectorUtils.isEmpty(str)) {
            return str;
        }
        if (ConnectorUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }
}

