/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.source.specialist;

import com.mulesoft.connectors.sharepoint.api.TriggersKeysApi;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.ObjectMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.source.specialist.AbstractObjectsSource;
import com.mulesoft.connectors.sharepoint.internal.source.specialist.TriggersKeys;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.source.PollContext;

@Alias(value="modified-objects", description="Listener for modified objects.")
@DisplayName(value="On Modified Objects")
@MetadataScope(outputResolver=ObjectMetadataResolver.class)
public class ModifiedObjectsSource
extends AbstractObjectsSource {
    private static final String TIME_LAST_MODIFIED = "TimeLastModified";
    private static final String LAST_ITEM_MODIFIED_DATE = "lastItemModifiedDate";
    private static final String MODIFIED = "Modified";

    public void poll(PollContext<Map<String, Object>, Serializable> pollContext) {
        this.handler.handle(pollContext, this.connection, () -> {
            Optional watermarkValue = pollContext.getWatermark();
            if (watermarkValue.isPresent()) {
                this.since = ((Serializable)watermarkValue.get()).toString();
            }
            String watermarkField = this.objectType.equals((Object)TriggersKeysApi.LIST) ? LAST_ITEM_MODIFIED_DATE : (this.objectType.equals((Object)TriggersKeysApi.LIST_ITEM) ? MODIFIED : TIME_LAST_MODIFIED);
            TriggersKeys.fromApiTrigger(this.objectType).executeQuery(pollContext, this.client, watermarkField, this.since, this.listId, this.recursive, this.path);
            return null;
        });
    }
}

