/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.source.specialist;

import com.mulesoft.connectors.sharepoint.api.TriggersKeysApi;
import com.mulesoft.connectors.sharepoint.internal.metadata.specialist.operations.ObjectMetadataResolver;
import com.mulesoft.connectors.sharepoint.internal.source.specialist.AbstractObjectsSource;
import com.mulesoft.connectors.sharepoint.internal.source.specialist.TriggersKeys;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.source.PollContext;

@Alias(value="created-objects", description="Listener for new objects.")
@DisplayName(value="On New Objects")
@MetadataScope(outputResolver=ObjectMetadataResolver.class)
public class CreatedObjectsSource
extends AbstractObjectsSource {
    private static final String TIME_CREATED = "TimeCreated";
    private static final String CREATED_LIST = "created";
    private static final String CREATED_LIST_ITEM = "Created";

    public void poll(PollContext<Map<String, Object>, Serializable> pollContext) {
        this.handler.handle(pollContext, this.connection, () -> {
            Optional watermarkValue = pollContext.getWatermark();
            if (watermarkValue.isPresent()) {
                this.since = ((Serializable)watermarkValue.get()).toString();
            }
            String watermarkField = this.objectType.equals((Object)TriggersKeysApi.LIST) ? CREATED_LIST : (this.objectType.equals((Object)TriggersKeysApi.LIST_ITEM) ? CREATED_LIST_ITEM : TIME_CREATED);
            TriggersKeys.fromApiTrigger(this.objectType).executeQuery(pollContext, this.client, watermarkField, this.since, this.listId, this.recursive, this.path);
            return null;
        });
    }
}

