/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.security.okta;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.OktaApiClient;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.OktaClientConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.runtime.api.connection.ConnectionException;

public abstract class OktaJsonApiClient
extends OktaApiClient {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-type";
    private static final String MEDIA_TYPE_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    protected ObjectMapper objectMapper;

    protected OktaJsonApiClient(OktaClientConfiguration config) {
        super(config);
    }

    @Override
    protected void initMarshaller() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JodaModule().addSerializer(DateTime.class, (JsonSerializer)new CustomDateTimeSerializer()));
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> T unmarshall(HttpResponse response, TypeReference<T> clazz) throws ConnectionException {
        JsonParser parser = null;
        try {
            if (response.getEntity() == null || clazz.getType().equals(Void.class)) {
                EntityUtils.consume((HttpEntity)response.getEntity());
                T t = null;
                return t;
            }
            InputStream inputStream = response.getEntity().getContent();
            parser = this.objectMapper.getFactory().createParser(inputStream);
            Object toReturn = parser.readValueAs(clazz);
            EntityUtils.consume((HttpEntity)response.getEntity());
            Object object = toReturn;
            return (T)object;
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected HttpEntity buildRequestEntity(Object object) throws ConnectionException {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = this.objectMapper.getFactory().createGenerator((Writer)writer);
            this.objectMapper.writeValue(generator, object);
            generator.close();
            writer.close();
            String string = writer.toString();
            return new StringEntity(string, UTF_8);
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setAcceptHeader(HttpUriRequest httpUriRequest) {
        BasicHeader acceptHeader = new BasicHeader(ACCEPT, MEDIA_TYPE_JSON);
        httpUriRequest.setHeader((Header)acceptHeader);
    }

    @Override
    protected void setContentTypeHeader(HttpUriRequest httpUriRequest) {
        BasicHeader contentTypeHeader = new BasicHeader(CONTENT_TYPE, MEDIA_TYPE_JSON);
        httpUriRequest.setHeader((Header)contentTypeHeader);
    }

    private class CustomDateTimeSerializer
    extends JsonSerializer<DateTime> {
        private final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();

        private CustomDateTimeSerializer() {
        }

        public void serialize(DateTime value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeString(this.formatter.print((ReadableInstant)value));
        }
    }
}

