/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.security.okta;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mulesoft.connectors.sharepoint.internal.error.SharepointErrorType;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.OktaClientConfiguration;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.OktaJsonApiClient;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.models.AuthResult;
import com.mulesoft.connectors.sharepoint.internal.service.utils.HtmlUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class OktaAuthApiClient
extends OktaJsonApiClient {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String RELAY_STATE = "relayState";
    private static final String CONTEXT = "context";
    private static final String AUTHORIZATION = "Authorization";
    private static final String WRESULT = "wresult";
    private static final String WCTX = "wctx";
    private static final String WA = "wa";
    private static final String UTF8 = "UTF-8";

    public OktaAuthApiClient(OktaClientConfiguration config) {
        super(config);
    }

    private static void samlFailHandler(CloseableHttpResponse responseSAML) throws ConnectionException {
        if (responseSAML.getStatusLine().getStatusCode() == 500) {
            String message = "Cannot reach Sharepoint Embedded Link.";
            throw new ConnectionException(message);
        }
        if (responseSAML.getStatusLine().getStatusCode() != 200) {
            String message = "Error when trying to call Sharepoint Embedded Link. HTTP error code : " + responseSAML.getStatusLine().getStatusCode();
            throw new ConnectionException(message);
        }
    }

    public AuthResult authenticate(String username, String password, String relayState) throws ConnectionException {
        return this.authenticate(username, password, relayState, "session_token", false);
    }

    public AuthResult authenticate(String username, String password, String relayState, String responseType, boolean forceMFA) throws ConnectionException {
        return this.authenticate(username, password, relayState, responseType, forceMFA, null);
    }

    public AuthResult authenticate(String username, String password, String relayState, String responseType, boolean forceMFA, Map<String, String> context) throws ConnectionException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USERNAME, username);
        params.put(PASSWORD, password);
        params.put(RELAY_STATE, relayState);
        params.put(CONTEXT, context);
        return this.post(this.getEncodedPath("?response_type=%s&force_mfa=%s", responseType, String.valueOf(forceMFA)), params, new TypeReference<AuthResult>(){});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> getSAMLArguments(String sharepointEmbeddedLink, String sessionToken) throws ConnectionException {
        CloseableHttpResponse responseSAML;
        Throwable throwable;
        HashMap<String, String> samlArguments = new HashMap<String, String>();
        String tmpString = "";
        String htmlLine = "";
        HtmlUtils htmlUtils = new HtmlUtils();
        HttpGet httpget = new HttpGet(sharepointEmbeddedLink + "?onetimetoken=" + sessionToken);
        httpget.setHeader((Header)new BasicHeader(AUTHORIZATION, String.format("SSWS %s", this.configuration.getApiToken())));
        try {
            throwable = null;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                responseSAML = httpClient.execute((HttpUriRequest)httpget);
                OktaAuthApiClient.samlFailHandler(responseSAML);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
        try {
            throwable = null;
            try (BufferedReader brSAML = new BufferedReader(new InputStreamReader(responseSAML.getEntity().getContent(), StandardCharsets.UTF_8));){
                while ((htmlLine = brSAML.readLine()) != null) {
                    if (htmlLine.contains(WRESULT)) {
                        tmpString = htmlUtils.getInputValue(htmlLine);
                        samlArguments.put(WRESULT, htmlUtils.getPlainText(tmpString));
                    }
                    if (!htmlLine.contains(WCTX)) continue;
                    tmpString = htmlUtils.getInputValue(htmlLine);
                    samlArguments.put(WCTX, htmlUtils.getPlainText(tmpString).replace("\n", ""));
                    break;
                }
                samlArguments.put(WA, "wsignin1.0");
                HashMap<String, String> hashMap = samlArguments;
                return hashMap;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected String getFullPath(String relativePath) {
        return String.format("/api/v1/authn%s", relativePath);
    }

    public String getSAMLToken(Map<String, String> authPayload) throws ConnectionException {
        try {
            byte[] out = this.buildOutputStream(authPayload);
            int length = out.length;
            URL url = new URL("https://login.microsoftonline.com/login.srf");
            URLConnection con = url.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            http.setInstanceFollowRedirects(true);
            http.setFixedLengthStreamingMode(length);
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            http.setRequestProperty("User-agent", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.215 Safari/535.1");
            http.connect();
            http.getOutputStream().write(out);
            BufferedReader htmlResponseReader = new BufferedReader(new InputStreamReader(http.getInputStream(), StandardCharsets.UTF_8));
            String htmlResponse = this.collectResponse(htmlResponseReader);
            if (!htmlResponse.contains("value=") || !htmlResponse.contains("</form>")) {
                throw new ModuleException("Unexpected response from server", (ErrorTypeDefinition)SharepointErrorType.CONNECTIVITY);
            }
            return htmlResponse.substring(htmlResponse.indexOf("value=") + 7, htmlResponse.indexOf("</form>") - 2);
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    private String collectResponse(BufferedReader htmlResponseReader) throws IOException {
        StringBuilder htmlBuilder = new StringBuilder();
        String currentLine = htmlResponseReader.readLine();
        while (currentLine != null) {
            htmlBuilder.append(currentLine);
            currentLine = htmlResponseReader.readLine();
        }
        return htmlBuilder.toString();
    }

    private byte[] buildOutputStream(Map<String, String> authPayload) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : authPayload.entrySet()) {
            builder.append(URLEncoder.encode(entry.getKey(), UTF8)).append("=").append(URLEncoder.encode(entry.getValue(), UTF8));
            builder.append("&");
        }
        return builder.toString().getBytes(StandardCharsets.UTF_8);
    }
}

