/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.security.okta;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mulesoft.connectors.sharepoint.internal.service.security.ErrorResponse;
import com.mulesoft.connectors.sharepoint.internal.service.security.okta.OktaClientConfiguration;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.message.BasicHeader;
import org.mule.runtime.api.connection.ConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OktaApiClient {
    private static final int RETRY_COUNT = 3;
    private static final String SDK_VERSION = "0.0.4";
    private static final Logger logger = LoggerFactory.getLogger(OktaApiClient.class);
    protected HttpClient httpClient;
    private String baseUrl;
    protected String token;
    protected OktaClientConfiguration configuration;
    private AtomicReference<HttpResponse> lastHttpResponseRef = new AtomicReference();

    protected OktaApiClient(OktaClientConfiguration config) {
        StandardHttpRequestRetryHandler requestRetryHandler = new StandardHttpRequestRetryHandler(3, true);
        this.httpClient = HttpClientBuilder.create().setRetryHandler((HttpRequestRetryHandler)requestRetryHandler).setUserAgent("OktaSDKJava_v0.0.4").disableCookieManagement().build();
        this.baseUrl = config.getBaseUrl();
        this.configuration = config;
        this.token = config.getApiToken();
        this.initMarshaller();
    }

    private static String encode(String str) throws ConnectionException {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void initMarshaller();

    protected abstract <T> T unmarshall(HttpResponse var1, TypeReference<T> var2) throws ConnectionException;

    protected abstract HttpEntity buildRequestEntity(Object var1) throws ConnectionException;

    protected abstract String getFullPath(String var1);

    protected abstract void setAcceptHeader(HttpUriRequest var1) throws ConnectionException;

    protected abstract void setContentTypeHeader(HttpUriRequest var1) throws ConnectionException;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    <T> T post(String uri, Object httpEntity, TypeReference<T> clazz) throws ConnectionException {
        return this.post(uri, this.buildRequestEntity(httpEntity), clazz);
    }

    private <T> T post(String uri, HttpEntity httpEntity, TypeReference<T> clazz) throws ConnectionException {
        HttpPost httpPost = new HttpPost();
        httpPost.setURI(this.getAbsoluteURI(uri));
        httpPost.setEntity(httpEntity);
        HttpResponse response = this.executeRequest((HttpUriRequest)httpPost);
        return this.unmarshallResponse(clazz, response);
    }

    private HttpResponse executeRequest(HttpUriRequest httpUriRequest) throws ConnectionException {
        this.logRequest(httpUriRequest);
        this.setHeaders(httpUriRequest);
        return this.doExecute(httpUriRequest);
    }

    private void logRequest(HttpUriRequest httpUriRequest) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("%s %s", httpUriRequest.getMethod(), httpUriRequest.getURI()));
        }
    }

    private void setHeaders(HttpUriRequest httpUriRequest) throws ConnectionException {
        this.setTokenHeader(httpUriRequest);
        this.setContentTypeHeader(httpUriRequest);
        this.setAcceptHeader(httpUriRequest);
    }

    private void setTokenHeader(HttpUriRequest httpUriRequest) {
        BasicHeader authHeader = new BasicHeader("Authorization", String.format("SSWS %s", this.token));
        httpUriRequest.setHeader((Header)authHeader);
    }

    private HttpResponse doExecute(HttpUriRequest httpUriRequest) throws ConnectionException {
        HttpResponse response;
        try {
            response = this.httpClient.execute(httpUriRequest);
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage());
        }
        this.lastHttpResponseRef.set(response);
        return response;
    }

    String getEncodedPath(String formatStr, String ... args) throws ConnectionException {
        return this.getFullPath(this.getEncodedString(formatStr, args));
    }

    private String getEncodedString(String formatStr, String[] args) throws ConnectionException {
        int argsLength = args.length;
        Object[] encodedArgs = new String[argsLength];
        for (int i = 0; i < argsLength; ++i) {
            encodedArgs[i] = OktaApiClient.encode(args[i]);
        }
        return String.format(formatStr, encodedArgs);
    }

    protected URI getAbsoluteURI(String relativeURI) throws ConnectionException {
        try {
            if (relativeURI.startsWith("http:") || relativeURI.startsWith("https:")) {
                return new URI(relativeURI);
            }
            return new URL(String.format("%s%s", this.baseUrl, relativeURI)).toURI();
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    private <T> T unmarshallResponse(TypeReference<T> clazz, HttpResponse httpResponse) throws ConnectionException {
        boolean contentReturned = this.checkResponse(httpResponse);
        if (contentReturned) {
            return this.unmarshall(httpResponse, clazz);
        }
        return null;
    }

    private boolean checkResponse(HttpResponse response) throws ConnectionException {
        if (response == null) {
            String message = "A response wasn't received";
            throw new ConnectionException(message);
        }
        StatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            String message = "A statusLine wasn't present in the response";
            throw new ConnectionException(message);
        }
        int statusCode = statusLine.getStatusCode();
        if ((statusCode == 200 || statusCode == 201) && response.getEntity() != null) {
            return true;
        }
        if (statusCode == 204 && response.getEntity() == null) {
            return false;
        }
        this.extractError(response);
        logger.info("We found an api exception and didn't throw an error");
        return false;
    }

    private void extractError(HttpResponse response) throws ConnectionException {
        String message;
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        ErrorResponse errors = this.unmarshall(response, new TypeReference<ErrorResponse>(){});
        switch (statusCode) {
            case 400: 
            case 401: {
                message = "You provided invalid Okta credentials, please try again.";
                break;
            }
            case 500: {
                message = "Please verify that your Okta org url is correct and try again";
                break;
            }
            default: {
                message = errors.getErrorSummary();
            }
        }
        throw new ConnectionException(message);
    }
}

