/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.proxy;

import com.mulesoft.connectors.sharepoint.api.EncodingCharset;
import com.mulesoft.connectors.sharepoint.internal.service.SharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.proxy.HttpClientContextPair;
import com.mulesoft.connectors.sharepoint.internal.service.rest.OnlineSharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.rest.OnpremiseSharepointService;
import com.mulesoft.connectors.sharepoint.internal.service.utils.ClientType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Map;
import javassist.util.proxy.ProxyFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public final class SharepointClientProxyFactory {
    private SharepointClientProxyFactory() {
    }

    public static SharepointService getProxy(EncodingCharset encodingCharset, ClientType connType, URL siteUrl, HttpClientContextPair clientContextPair, Map<String, String> headers) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ProxyFactory factory = new ProxyFactory();
        if (connType.equals((Object)ClientType.ONLINE)) {
            factory.setSuperclass(OnlineSharepointService.class);
        } else if (connType.equals((Object)ClientType.ONPREMISE)) {
            factory.setSuperclass(OnpremiseSharepointService.class);
        }
        factory.setFilter(m -> {
            if (m.getName().equals("init") || m.getName().equals("close")) {
                return false;
            }
            return Modifier.isPublic(m.getModifiers());
        });
        return (SharepointService)factory.create(new Class[]{EncodingCharset.class, CloseableHttpClient.class, HttpContext.class, URL.class, Map.class}, new Object[]{encodingCharset, clientContextPair.getClient(), clientContextPair.getContext(), siteUrl, headers}, (self, thisMethod, proceed, args) -> {
            try {
                return proceed.invoke(self, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        });
    }
}

