/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.service.mapping.entity;

import com.mulesoft.connectors.sharepoint.internal.error.exception.SharepointException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharepointBlobEntity
extends AbstractHttpEntity {
    private static final Logger logger = LoggerFactory.getLogger(SharepointBlobEntity.class);
    private Object input;
    private InputStream content;
    private long contentLength = -1L;

    public SharepointBlobEntity(Object input) {
        this.checkSupportedInput(input);
        this.input = input;
        this.setContentType(ContentType.APPLICATION_OCTET_STREAM.toString());
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        if (this.contentLength != -1L) {
            return this.contentLength;
        }
        if (this.input instanceof ByteArrayInputStream) {
            this.contentLength = ((ByteArrayInputStream)this.input).available();
        } else if (this.input instanceof InputStream) {
            try {
                BlobChunks blobChunks = new BlobChunks(4096).acquireFrom((InputStream)this.input);
                this.contentLength = blobChunks.getTotalLength();
                this.input = new BlobChunksInputStream(blobChunks);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else if (this.input instanceof File) {
            this.contentLength = ((File)this.input).length();
        }
        return this.contentLength;
    }

    public InputStream getContent() throws IOException {
        if (this.content == null) {
            if (this.input instanceof InputStream) {
                this.content = (InputStream)this.input;
            } else if (this.input instanceof File) {
                this.content = new FileInputStream((File)this.input);
            }
        }
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        InputStream instream = this.getContent();
        Args.notNull((Object)instream, (String)"Input stream");
        try {
            int l;
            byte[] buffer = new byte[4096];
            while ((l = instream.read(buffer)) != -1) {
                outstream.write(buffer, 0, l);
            }
            outstream.flush();
        }
        finally {
            instream.close();
        }
    }

    public boolean isStreaming() {
        return false;
    }

    private void checkSupportedInput(Object input) {
        if (input instanceof InputStream || input instanceof File) {
            return;
        }
        throw new SharepointException("Input type not supported yet.", null);
    }

    private class BlobChunksInputStream
    extends InputStream {
        private final BlobChunks blobChunks;
        private int index;

        public BlobChunksInputStream(BlobChunks blobChunks) {
            this.blobChunks = blobChunks;
            this.index = 0;
        }

        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.index >= this.blobChunks.size()) {
                return -1;
            }
            byte[] src = (byte[])this.blobChunks.get(this.index);
            int length = this.index == this.blobChunks.size() - 1 ? this.blobChunks.getLastChunkLength() : this.blobChunks.getDefaultChunkLength();
            System.arraycopy(src, 0, b, 0, length);
            this.blobChunks.set(this.index++, null);
            return length;
        }
    }

    private class BlobChunks
    extends ArrayList<byte[]> {
        private static final long serialVersionUID = -8880523573512896181L;
        private final int defaultChunkLength;
        private int lastChunkLength;
        private long totalLength;

        public BlobChunks(int defaultChunkLength) {
            this.defaultChunkLength = defaultChunkLength;
        }

        public BlobChunks acquireFrom(InputStream input) throws IOException {
            int l;
            this.clear();
            byte[] buffer = new byte[this.defaultChunkLength];
            while ((l = input.read(buffer)) != -1) {
                this.add(buffer.clone());
                this.lastChunkLength = l;
                this.totalLength += (long)l;
            }
            input.close();
            return this;
        }

        public int getDefaultChunkLength() {
            return this.defaultChunkLength;
        }

        public int getLastChunkLength() {
            return this.lastChunkLength;
        }

        public long getTotalLength() {
            return this.totalLength;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobChunks)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BlobChunks bytes = (BlobChunks)o;
            if (this.defaultChunkLength != bytes.defaultChunkLength) {
                return false;
            }
            if (this.lastChunkLength != bytes.lastChunkLength) {
                return false;
            }
            return this.totalLength == bytes.totalLength;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.defaultChunkLength;
            result = 31 * result + this.lastChunkLength;
            result = 31 * result + (int)(this.totalLength ^ this.totalLength >>> 32);
            return result;
        }
    }
}

