/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.sharepoint.internal.paging;

import com.mulesoft.connectors.sharepoint.internal.paging.TaxonomyResolutionContext;
import com.mulesoft.connectors.sharepoint.internal.service.mapping.entity.SharepointListOfMapResult;
import com.mulesoft.connectors.sharepoint.internal.service.utils.caching.impl.CacheResolutionProvider;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.uri.UriComponent;
import org.glassfish.jersey.uri.UriTemplate;

class TaxonomyResolutionProvider
implements CacheResolutionProvider<String, TaxonomyResolutionContext, Object> {
    private static final Pattern ITEMURIREGEX = Pattern.compile(".*\\/Items\\((.+)\\)$");

    TaxonomyResolutionProvider() {
    }

    @Override
    public Object resolve(TaxonomyResolutionContext context) {
        String field = String.format("<ViewFields><FieldRef Name=\"%s\"/></ViewFields>", context.getLookupField().getKey());
        String where = String.format("<Where><Eq><FieldRef Name=\"ID\"/><Value Type=\"Counter\">%s</Value></Eq></Where>", this.getIdValueFromMetadata((Map)context.getItem().get("__metadata")));
        String query = "<Query>" + where + "</Query>";
        String view = "<View>" + field + query + "<ViewFieldsOnly>true</ViewFieldsOnly></View>";
        String body = "{'query':{'__metadata':{ 'type': 'SP.CamlQuery' },'ViewXml':'" + view + "'}}";
        Object result = null;
        UriTemplate uriTemplate = new UriTemplate("_api/web/lists/getByTitle('" + context.getListId() + "')/getitems");
        UriBuilder uriBuilder = UriBuilder.fromPath((String)uriTemplate.getTemplate());
        String path = UriComponent.decode((String)uriBuilder.build(new Object[]{UriTemplate.EMPTY}).toString(), (UriComponent.Type)UriComponent.Type.QUERY_PARAM);
        SharepointListOfMapResult data = context.getService().resolvePost(path, body, SharepointListOfMapResult.class);
        if (!data.getResults().isEmpty()) {
            result = data.getResults().get(0).get(context.getLookupField().getKey());
        }
        return result;
    }

    private Integer getIdValueFromMetadata(Map<String, Object> metadata) {
        Matcher m = ITEMURIREGEX.matcher(metadata.get("uri").toString());
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return -1;
    }
}

